const { exec } = require("child_process");
const { uniqueNamesGenerator, adjectives, colors, animals } = require('unique-names-generator');

const hbrs = [
	"canadacentral",
	"westus2",
	"eastus",
	"southcentralus",
	"northcentralus",
	"westeurope",
]

const locations = [
	"eastus",
	"southcentralus",
	"northcentralus",
	"northeurope",
	"westus"
]

for (let runs = 0; runs <= 5; runs++) {
	exec(returnServerCreateCommand(hbrs[ runs ], uniqueNamesGenerator({ dictionaries: [ adjectives, animals, colors ], length: 3 }), "Standard_HB120rs_v2"), (err, stdout, stderr) => {
		console.log(stdout);
		console.log(stderr);
	})
}

for (let runs = 0; runs <= 2; runs++) {
	locations.forEach(location => {
		exec(returnServerCreateCommand(location, uniqueNamesGenerator({ dictionaries: [ adjectives, animals, colors ], length: 3 }), "Standard_E96a_v4"), (err, stdout, stderr) => {
			console.log(stdout);
			console.log(stderr);
		})
	})
}

for (let runs = 0; runs <= 2; runs++) {
	locations.forEach(location => {
		exec(returnServerCreateCommand(location, uniqueNamesGenerator({ dictionaries: [ adjectives, animals, colors ], length: 3 }), "Standard_E96as_v4"), (err, stdout, stderr) => {
			console.log(stdout);
			console.log(stderr);
		})
	})
}

for (let runs = 0; runs <= 2; runs++) {
	locations.forEach(location => {
		exec(returnServerCreateCommand(location, uniqueNamesGenerator({ dictionaries: [ adjectives, animals, colors ], length: 3 }), "Standard_D96a_v4"), (err, stdout, stderr) => {
			console.log(stdout);
			console.log(stderr);
		})
	})
}

for (let runs = 0; runs <= 2; runs++) {
	locations.forEach(location => {
		exec(returnServerCreateCommand(location, uniqueNamesGenerator({ dictionaries: [ adjectives, animals, colors ], length: 3 }), "Standard_D96as_v4"), (err, stdout, stderr) => {
			console.log(stdout);
			console.log(stderr);
		})
	})
}

function returnServerCreateCommand(location, name, size) {
	return `az vm create --admin-username azureuser --admin-password WojtekCwel1! --authentication-type password --image Canonical:0001-com-ubuntu-server-focal:20_04-lts:latest --public-ip-sku Standard --no-wait --location ${location} --size ${size} --name ${name}`
}