/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.client.model;

import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import twistedgate.immersiveposts.client.model.IPOBakedModel;
import twistedgate.immersiveposts.client.model.IPOModelData;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;

public class PostBaseModel
extends IPOBakedModel {
    public static final Cache<Key, SpecialPostBaseModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    static TextureAtlasSprite postbaseSprite;

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Key key;
        SpecialPostBaseModel special;
        BlockState hState = Blocks.f_50493_.m_49966_();
        Int2IntFunction colorMul = i -> -1;
        Direction facing = Direction.NORTH;
        if (extraData.hasProperty(IPOModelData.POSTBASE)) {
            IPOModelData.PostBaseModelData data = (IPOModelData.PostBaseModelData)extraData.getData(IPOModelData.POSTBASE);
            hState = data.state;
            colorMul = data.color;
            facing = data.facing;
        }
        if ((special = (SpecialPostBaseModel)CACHE.getIfPresent((Object)(key = new Key(hState, colorMul, facing)))) == null) {
            special = new SpecialPostBaseModel(key, colorMul);
            CACHE.put((Object)key, (Object)special);
        }
        return special.m_6840_(state, side, rand);
    }

    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(tileData);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PostBaseTileEntity) {
            PostBaseTileEntity base = (PostBaseTileEntity)te;
            IPOModelData.PostBaseModelData data = new IPOModelData.PostBaseModelData(base.getCoverState(), base.getFacing(), i -> i);
            list.add(new SinglePropertyModelData((Object)data, IPOModelData.POSTBASE));
        }
        return CombinedModelData.combine((IModelData[])list.toArray(new IModelData[0]));
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    static TextureAtlasSprite getPostbaseSprite() {
        if (postbaseSprite == null) {
            postbaseSprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("immersiveposts", "block/postbase"));
        }
        return postbaseSprite;
    }

    public TextureAtlasSprite m_6160_() {
        return PostBaseModel.getPostbaseSprite();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static class Key {
        final BlockState state;
        final Direction facing;
        @Nullable
        Int2IntMap usedColorMultipliers;
        @Nullable
        final Int2IntFunction allColorMultipliers;

        public Key(BlockState state, Int2IntFunction colorMul, Direction facing) {
            this.state = state;
            this.facing = facing;
            this.allColorMultipliers = colorMul;
            this.usedColorMultipliers = null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof Key) {
                Key other = (Key)obj;
                return this.state.equals(other.state) && this.facing == other.facing && this.sameColorMultipliersAs(other);
            }
            return false;
        }

        private boolean sameColorMultipliersAs(Key that) {
            if (that.usedColorMultipliers != null && this.usedColorMultipliers != null) {
                return this.usedColorMultipliers.equals(that.usedColorMultipliers);
            }
            if (that.usedColorMultipliers != null && this.allColorMultipliers != null) {
                IntIterator intIterator = that.usedColorMultipliers.keySet().iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    if (this.allColorMultipliers.get(i) == that.usedColorMultipliers.get(i)) continue;
                    return false;
                }
                return true;
            }
            if (that.allColorMultipliers != null && this.usedColorMultipliers != null) {
                return that.sameColorMultipliersAs(this);
            }
            throw new IllegalStateException("Can't compare PostBaseModel. Key's that use functions!");
        }

        public int hashCode() {
            return 31 * this.state.hashCode() + Objects.hash(this.facing);
        }
    }

    private static class SpecialPostBaseModel
    extends PostBaseModel {
        private static final Random RANDOM = new Random();
        private static final Vec3[] verts = new Vec3[]{new Vec3(0.25, (double)1.001f, 0.25), new Vec3(0.25, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.25)};
        private static final double[] uvs = new double[]{8.0, 0.0, 16.0, 8.0};
        private static final float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecialPostBaseModel(Key key, Int2IntFunction colorMul) {
            this.build(key, colorMul);
        }

        private void build(Key key, Int2IntFunction colorMulBasic) {
            if (colorMulBasic == null) {
                ItemColors colors = Minecraft.m_91087_().getItemColors();
                ItemStack stack = new ItemStack((ItemLike)key.state.m_60734_());
                colorMulBasic = i -> colors.m_92676_(stack, i);
            }
            key.usedColorMultipliers = new Int2IntOpenHashMap();
            Int2IntFunction f = colorMulBasic;
            Int2IntFunction colorMul = i -> {
                int v = f.get(i);
                key.usedColorMultipliers.put(i, v);
                return v;
            };
            QuadTransformer tintTransformer = new QuadTransformer(Transformation.m_121093_(), colorMul);
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(key.state);
            for (Direction side : Direction.values()) {
                List quads = model.getQuads(key.state, side, RANDOM, (IModelData)EmptyModelData.INSTANCE).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new));
                if (side == Direction.UP) {
                    TextureAtlasSprite sprite = SpecialPostBaseModel.getPostbaseSprite();
                    quads.add(ModelUtils.createBakedQuad((Vec3[])verts, (Direction)side, (TextureAtlasSprite)sprite, (double[])uvs, (float[])color, (boolean)false));
                }
                this.quads.add(quads);
            }
            this.quads.add((List<BakedQuad>)ImmutableList.of());
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            return this.quads.get(side == null ? this.quads.size() - 1 : side.m_122411_());
        }
    }
}

