/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFGenHollowTree;

public class TFGenHollowStump
extends TFGenHollowTree {
    public TFGenHollowStump(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(WorldGenLevel world, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        int radius = random.nextInt(2) + 2;
        if (!FeatureUtil.isAreaSuitable(world, pos.m_142082_(-radius, 0, -radius), 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, radius, 3, 2, 6, 0.75, 3, 5, 3, false, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, radius, 1, 2, 8, 0.9, 3, 5, 3, false, config);
        this.buildTrunk((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos, radius, 6, config);
        return true;
    }

    @Override
    protected void buildTrunk(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> decoPlacer, Random random, BlockPos pos, int diameter, int maxheight, TFTreeFeatureConfig config) {
        int dz;
        int dx;
        int hollow = diameter >> 1;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.m_142082_(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.trunkProvider);
                        continue;
                    }
                    FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decoPlacer, random, dPos, config.rootsProvider);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = Math.max(ax, az = Math.abs(dz)) + (Math.min(ax, az) >> 1);
                    if (dist > diameter || dist <= hollow) continue;
                    FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.m_142082_(dx, dy, dz), config.trunkProvider);
                }
            }
        }
    }
}

