/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.item.TFItems;

public class LichShadowsGoal
extends Goal {
    private final Lich lich;

    public LichShadowsGoal(Lich boss) {
        this.lich = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.lich.getPhase() == 1;
    }

    public void m_8056_() {
        this.lich.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.TWILIGHT_SCEPTER.get()));
    }

    public void m_8041_() {
        this.despawnClones();
    }

    public void m_8037_() {
        LivingEntity targetedEntity;
        if (this.lich.isShadowClone()) {
            this.checkForMaster();
        }
        if ((targetedEntity = this.lich.m_5448_()) == null) {
            return;
        }
        float dist = this.lich.m_20270_((Entity)targetedEntity);
        if (this.lich.getAttackCooldown() == 60) {
            this.lich.teleportToSightOfEntity((Entity)targetedEntity);
            if (!this.lich.isShadowClone()) {
                this.checkAndSpawnClones();
            }
        }
        if (this.lich.m_21574_().m_148306_((Entity)targetedEntity) && this.lich.getAttackCooldown() == 0 && dist < 20.0f) {
            if (this.lich.getNextAttackType() == 0) {
                this.lich.launchProjectileAt(new LichBolt(this.lich.m_183503_(), (LivingEntity)this.lich));
            } else {
                this.lich.launchProjectileAt(new LichBomb(this.lich.m_183503_(), (LivingEntity)this.lich));
            }
            this.lich.m_6674_(InteractionHand.MAIN_HAND);
            if (this.lich.m_21187_().nextInt(3) > 0) {
                this.lich.setNextAttackType(0);
            } else {
                this.lich.setNextAttackType(1);
            }
            this.lich.setAttackCooldown(100);
        }
    }

    private void checkForMaster() {
        if (this.lich.getMasterLich() == null) {
            this.findNewMaster();
        }
        if (!(this.lich.m_183503_().m_5776_() || this.lich.getMasterLich() != null && this.lich.getMasterLich().m_6084_())) {
            this.lich.m_146870_();
        }
    }

    private void checkAndSpawnClones() {
        if (this.lich.countMyClones() < 2) {
            this.spawnShadowClone();
        }
    }

    private void spawnShadowClone() {
        LivingEntity targetedEntity = this.lich.m_5448_();
        Vec3 cloneSpot = this.lich.findVecInLOSOf((Entity)targetedEntity);
        if (cloneSpot != null) {
            Lich newClone = new Lich(this.lich.m_183503_(), this.lich);
            newClone.m_6034_(cloneSpot.f_82479_, cloneSpot.f_82480_, cloneSpot.f_82481_);
            this.lich.m_183503_().m_7967_((Entity)newClone);
            newClone.m_6710_(targetedEntity);
            newClone.setAttackCooldown(60 + this.lich.m_21187_().nextInt(3) - this.lich.m_21187_().nextInt(3));
            this.lich.makeTeleportTrail(this.lich.m_20185_(), this.lich.m_20186_(), this.lich.m_20189_(), cloneSpot.f_82479_, cloneSpot.f_82480_, cloneSpot.f_82481_);
        }
    }

    private void despawnClones() {
        for (Lich lich : this.lich.getNearbyLiches()) {
            if (!lich.isShadowClone()) continue;
            lich.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void findNewMaster() {
        for (Lich lich : this.lich.getNearbyLiches()) {
            if (lich.isShadowClone() || !lich.wantsNewClone(this.lich)) continue;
            this.lich.setMaster(lich);
            this.lich.makeTeleportTrail(this.lich.m_20185_(), this.lich.m_20186_(), this.lich.m_20189_(), lich.m_20185_(), lich.m_20186_(), lich.m_20189_());
            this.lich.m_6710_(lich.m_5448_());
            break;
        }
    }
}

