/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;
import twilightforest.TwilightForestMod;
import twilightforest.item.recipe.TFRecipes;

public abstract class TransformationPowderProvider
implements DataProvider {
    private final DataGenerator generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Pair<EntityType<?>, EntityType<?>>> builders = Maps.newLinkedHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public TransformationPowderProvider(DataGenerator generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public void m_6865_(HashCache cache) throws IOException {
        this.builders.clear();
        this.registerTransforms();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> ForgeRegistries.ENTITIES.containsKey(((EntityType)transform.getA()).getRegistryName())).filter(s -> ForgeRegistries.ENTITIES.containsKey(((EntityType)transform.getB()).getRegistryName())).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Transformation Powder Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((EntityType)transform.getA(), (EntityType)transform.getB());
            Path path = this.createPath(new ResourceLocation(this.modId, name));
            try {
                String s2 = GSON.toJson((JsonElement)obj);
                String s1 = f_123918_.hashUnencodedChars((CharSequence)s2).toString();
                if (!Objects.equals(cache.m_123938_(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s2);
                    }
                }
                cache.m_123940_(path, s1);
            }
            catch (IOException ioexception) {
                TwilightForestMod.LOGGER.error("Couldn't save Transformation Powder recipe to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new ResourceLocation(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "crumble_horn/"));
    }

    private Path createPath(ResourceLocation name) {
        return this.generator.m_123916_().resolve("data/" + name.m_135827_() + "/recipes/transformation_powder/" + name.m_135815_() + ".json");
    }

    private JsonObject serializeToJson(EntityType<?> transformFrom, EntityType<?> transformTo) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", ((RecipeSerializer)TFRecipes.TRANSFORMATION_SERIALIZER.get()).getRegistryName().toString());
        jsonobject.addProperty("from", ForgeRegistries.ENTITIES.getKey(transformFrom).toString());
        jsonobject.addProperty("to", ForgeRegistries.ENTITIES.getKey(transformTo).toString());
        return jsonobject;
    }

    public String m_6055_() {
        return this.modId + " Transformation Powder Transformations";
    }

    public void addSingleTransform(EntityType<?> from, EntityType<?> to) {
        this.builders.put(from.getRegistryName().m_135815_() + "_to_" + to.getRegistryName().m_135815_(), new Pair(from, to));
    }

    public void addTwoWayTransform(EntityType<?> from, EntityType<?> to) {
        this.builders.put(from.getRegistryName().m_135815_() + "_to_" + to.getRegistryName().m_135815_(), new Pair(from, to));
        this.builders.put(to.getRegistryName().m_135815_() + "_to_" + from.getRegistryName().m_135815_(), new Pair(to, from));
    }
}

