/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.TwilightChest;
import twilightforest.data.tags.ItemTagGenerator;

public abstract class CraftingDataHelper
extends RecipeProvider {
    public CraftingDataHelper(DataGenerator generator) {
        super(generator);
    }

    protected final Ingredient itemWithNBT(RegistryObject<? extends ItemLike> item, Consumer<CompoundTag> nbtSetter) {
        return this.itemWithNBT((ItemLike)item.get(), nbtSetter);
    }

    protected final Ingredient itemWithNBT(ItemLike item, Consumer<CompoundTag> nbtSetter) {
        ItemStack stack = new ItemStack(item);
        CompoundTag nbt = new CompoundTag();
        nbtSetter.accept(nbt);
        stack.m_41751_(nbt);
        try {
            Constructor constructor = NBTIngredient.class.getDeclaredConstructor(ItemStack.class);
            constructor.setAccessible(true);
            return (Ingredient)constructor.newInstance(stack);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        }
    }

    protected final Ingredient multipleIngredients(Ingredient ... ingredientArray) {
        ImmutableList ingredientList = ImmutableList.copyOf((Object[])ingredientArray);
        try {
            Constructor constructor = CompoundIngredient.class.getDeclaredConstructor(List.class);
            constructor.setAccessible(true);
            return (Ingredient)constructor.newInstance(ingredientList);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Ingredient.merge((Collection)ingredientList);
        }
    }

    protected final void charmRecipe(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, Supplier<? extends Item> item) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)result.get())).m_126211_((ItemLike)item.get(), 4).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)item.get()))).m_142700_(consumer, TwilightForestMod.prefix(name));
    }

    protected final void castleBlock(Consumer<FinishedRecipe> consumer, Supplier<? extends Block> result, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("##").m_126130_("##").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_142284_("has_castle_brick", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).m_142700_(consumer, this.locCastle(result.get().getRegistryName().m_135815_()));
    }

    protected final void stairsBlock(Consumer<FinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)8).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)criteria.get()))).m_142700_(consumer, loc);
    }

    protected final void stairsRightBlock(Consumer<FinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)8).m_126130_("###").m_126130_(" ##").m_126130_("  #").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)criteria.get()))).m_142700_(consumer, loc);
    }

    protected final void compressedBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, TagKey<Item> ingredient) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), ingredient).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(ingredient)).m_142700_(consumer, TwilightForestMod.prefix("compressed_blocks/" + name));
    }

    protected final void reverseCompressBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> ingredient) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)9).m_206419_(ingredient).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(ingredient)).m_142700_(consumer, TwilightForestMod.prefix("compressed_blocks/reversed/" + name));
    }

    protected final void helmetItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void chestplateItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("# #").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), material).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void leggingsItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("# #").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void bootsItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("# #").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void pickaxeItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void swordItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("#").m_126130_("#").m_126130_("X").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void axeItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("##").m_126130_("#X").m_126130_(" X").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(material)).m_142700_(consumer, this.locEquip(name));
    }

    protected final void buttonBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)result.get())).m_126209_((ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_button"));
    }

    protected final void doorBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_door"));
    }

    protected final void fenceBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("#S#").m_126130_("#S#").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_fence"));
    }

    protected final void gateBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("S#S").m_126130_("S#S").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_gate"));
    }

    protected final void planksBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)4).m_126209_((ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_planks"));
    }

    protected final void plateBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_plate"));
    }

    protected final void slabBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_slab"));
    }

    protected final void bannerPattern(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> trophy, Supplier<? extends Item> result) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)result.get())).m_126184_(Ingredient.m_204132_(ItemTagGenerator.PAPER)).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{trophy.get().m_5456_()})).m_142284_("has_trophy", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)trophy.get()))).m_176498_(consumer);
    }

    protected final void trapdoorBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_trapdoor"));
    }

    protected final void woodBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_wood"));
    }

    protected final void strippedWoodBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_stripped_wood"));
    }

    protected final void signBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("###").m_126130_("###").m_126130_(" - ").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('-'), Tags.Items.RODS_WOODEN).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_wood"));
    }

    protected final void banisterBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        this.banisterBlock(consumer, name, result, material.get());
    }

    protected final void banisterBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Block material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("---").m_126130_("| |").m_126127_(Character.valueOf('-'), (ItemLike)material).m_206416_(Character.valueOf('|'), Tags.Items.RODS_WOODEN).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)material)).m_142700_(consumer, this.locWood(name + "_banister"));
    }

    protected final void chestBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends TwilightChest> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("###").m_126130_("#C#").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_142700_(consumer, this.locWood(name + "_chest"));
    }

    protected final void fieryConversion(Consumer<FinishedRecipe> consumer, Supplier<? extends Item> result, Item armor, int vials) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)result.get())).m_126209_((ItemLike)armor).m_126186_(Ingredient.m_204132_(ItemTagGenerator.FIERY_VIAL), vials).m_142284_("has_item", (CriterionTriggerInstance)CraftingDataHelper.has(ItemTagGenerator.FIERY_VIAL)).m_142700_(consumer, this.locEquip("fiery_" + armor.getRegistryName().m_135815_()));
    }

    protected final ResourceLocation locCastle(String name) {
        return TwilightForestMod.prefix("castleblock/" + name);
    }

    protected final ResourceLocation locEquip(String name) {
        return TwilightForestMod.prefix("equipment/" + name);
    }

    protected final ResourceLocation locNaga(String name) {
        return TwilightForestMod.prefix("nagastone/" + name);
    }

    protected final ResourceLocation locWood(String name) {
        return TwilightForestMod.prefix("wood/" + name);
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> p_206407_) {
        return CraftingDataHelper.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_()});
    }
}

