/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.ie;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TwilightForestMod;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.item.TFItems;

public class TFShaderItem
extends Item
implements IShaderItem {
    static final String TAG_SHADER = "shader_name";

    public TFShaderItem() {
        super(TFItems.defaultBuilder().m_41487_(1));
    }

    public ShaderCase getShaderCase(ItemStack shader, ResourceLocation shaderType) {
        return ShaderRegistry.getShader((ResourceLocation)this.getShaderName(shader), (ResourceLocation)shaderType);
    }

    public ResourceLocation getShaderName(ItemStack stack) {
        return TFShaderItem.getShaderType(stack);
    }

    public Component m_7626_(ItemStack stack) {
        String localizedShaderName;
        ResourceLocation rawShaderName = this.getShaderName(stack);
        String unlocalizedShaderName = "item." + rawShaderName.m_135827_() + ".shader.name." + rawShaderName.m_135815_().replace(' ', '_').toLowerCase(Locale.ROOT);
        if (unlocalizedShaderName.equals(localizedShaderName = new TranslatableComponent(unlocalizedShaderName).getString())) {
            return new TranslatableComponent(this.m_5671_(stack), new Object[]{rawShaderName.m_135815_()}).m_130946_(" *TRANSLATION FAILURE*").m_130940_(ChatFormatting.DARK_RED);
        }
        return new TranslatableComponent(this.m_5671_(stack), new Object[]{localizedShaderName});
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ResourceLocation name = this.getShaderName(ctx.m_43722_());
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            BlockState blockState = world.m_8055_(pos);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BannerBlockEntity) {
                ShaderCase sCase = ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(name)).getCase(new ResourceLocation("immersiveengineering", "banner"));
                if (sCase != null) {
                    boolean wall = blockState.m_60734_() instanceof WallBannerBlock;
                    if (wall) {
                        world.m_46597_(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER_WALL.defaultBlockState().m_61124_(ShaderBannerWallBlock.FACING, (Comparable)((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_))));
                    } else {
                        world.m_46597_(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER.defaultBlockState().m_61124_((Property)ShaderBannerStandingBlock.ROTATION, (Comparable)((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_))));
                    }
                    tile = world.m_7702_(pos);
                    if (tile instanceof ShaderBannerBlockEntity) {
                        ShaderBannerBlockEntity sb = (ShaderBannerBlockEntity)tile;
                        sb.shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.m_43722_(), (int)1));
                        tile.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof ShaderBannerBlockEntity) {
                ShaderBannerBlockEntity sb = (ShaderBannerBlockEntity)tile;
                sb.shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.m_43722_(), (int)1));
                sb.m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.shader.level").m_7220_((Component)TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.shader.rarity." + this.m_41460_(stack).name().toLowerCase(Locale.US)), (ChatFormatting[])new ChatFormatting[]{this.m_41460_((ItemStack)stack).f_43022_})));
        if (ShaderRegistry.shaderRegistry.containsKey(this.getShaderName(stack))) {
            if (!Screen.m_96638_()) {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.shader.applyTo").m_130946_(" ").m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.holdShift")));
            } else {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.shader.applyTo"));
                for (ShaderCase sCase : ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(this.getShaderName(stack))).getCases()) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.shader." + sCase.getShaderType()), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
                }
            }
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return ShaderRegistry.shaderRegistry.containsKey(this.getShaderName(stack)) ? ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(this.getShaderName(stack))).getRarity() : Rarity.COMMON;
    }

    public static ResourceLocation getShaderType(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)TAG_SHADER) ? new ResourceLocation(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SHADER)) : TwilightForestMod.prefix("twilight");
    }

    public static int getShaderColors(ItemStack stack, int pass) {
        ShaderCase sCase;
        ResourceLocation name = TFShaderItem.getShaderType(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(name)).getCase(new ResourceLocation("immersiveengineering", "item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return Utils.intFromRGBA((Vector4f)layers[pass].getColor());
            }
            return -1;
        }
        return -1;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == TFItems.creativeTab) {
            for (ShaderRegistry.ShaderRegistryEntry entry : IEShaderRegister.getAllTwilightShaders()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemNBTHelper.putString((ItemStack)stack, (String)TAG_SHADER, (String)entry.getName().toString());
                items.add((Object)stack);
            }
        }
    }
}

