/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.HydraHeadModel;
import twilightforest.client.renderer.entity.TFPartRenderer;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraHeadContainer;

public class HydraHeadRenderer
extends TFPartRenderer<HydraHead, HydraHeadModel> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraHeadRenderer(EntityRendererProvider.Context manager) {
        super(manager, new HydraHeadModel(manager.m_174023_(TFModelLayers.HYDRA_HEAD)));
    }

    @Override
    public void render(HydraHead entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        HydraHeadContainer headCon = HydraHeadRenderer.getHeadObject(entity);
        if (headCon != null) {
            if (headCon.shouldRenderHead()) {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
                super.render(entity, yaw, partialTicks, stack, buffer, light);
            }
        } else {
            super.render(entity, yaw, partialTicks, stack, buffer, light);
        }
    }

    @Nullable
    public static HydraHeadContainer getHeadObject(HydraHead entity) {
        Hydra hydra = (Hydra)entity.getParent();
        if (hydra != null) {
            for (int i = 0; i < hydra.numHeads; ++i) {
                if (hydra.hc[i].headEntity != entity) continue;
                return hydra.hc[i];
            }
        }
        return null;
    }

    public ResourceLocation getTextureLocation(HydraHead entity) {
        return textureLoc;
    }
}

