/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractParticleSpawnerBlock;
import twilightforest.block.TFBlocks;
import twilightforest.client.particle.TFParticleType;

public class FireflySpawnerBlock
extends AbstractParticleSpawnerBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public FireflySpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        super.m_7100_(state, level, pos, rand);
        if (rand.nextInt(5) == 0) {
            double dx = (float)pos.m_123341_() + ((rand.nextFloat() - rand.nextFloat()) * 0.2f + 0.5f);
            double dy = (float)pos.m_123342_() + 0.4f + (rand.nextFloat() - rand.nextFloat()) * 0.3f;
            double dz = (float)pos.m_123343_() + ((rand.nextFloat() - rand.nextFloat()) * 0.2f + 0.5f);
            level.m_7106_((ParticleOptions)TFParticleType.FIREFLY.get(), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ((Block)TFBlocks.FIREFLY.get()).m_5456_() && !player.m_6144_() && (Integer)state.m_61143_((Property)RADIUS) < 10) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)RADIUS) + 1)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_5661_((Component)new TranslatableComponent("block.twilightforest.firefly_spawner_radius", new Object[]{(Integer)state.m_61143_((Property)RADIUS) + 1}), true);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_6144_() && (Integer)state.m_61143_((Property)RADIUS) > 1) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)RADIUS) - 1)));
            ItemEntity bug = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)TFBlocks.FIREFLY.get()));
            level.m_7967_((Entity)bug);
            player.m_5661_((Component)new TranslatableComponent("block.twilightforest.firefly_spawner_radius", new Object[]{(Integer)state.m_61143_((Property)RADIUS) - 1}), true);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @Override
    public ParticleType<?> getParticlesToSpawn() {
        return (ParticleType)TFParticleType.JAR_WANDERING_FIREFLY.get();
    }

    @Override
    public int getParticleCountPerSpawn(BlockState state) {
        return (int)Math.ceil((double)((Integer)state.m_61143_((Property)RADIUS)).intValue() / 2.0);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_192917_((Fluid)Fluids.f_76193_);
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

