/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.utils;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import customskinloader.CustomSkinLoader;
import customskinloader.utils.HttpTextureUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class TextureUtil {
    public static String parseBase64Texture(String base64) {
        byte[] capeBytes = Base64.decodeBase64((String)base64);
        String hash = HttpTextureUtil.getHash(capeBytes);
        File cacheFile = HttpTextureUtil.getCacheFile(hash);
        String fakeUrl = HttpTextureUtil.getBase64FakeUrl(hash);
        try {
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])capeBytes);
            CustomSkinLoader.logger.info("Saved base64 image to " + cacheFile);
            return fakeUrl;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.warning("Error parsing base64 image: " + base64);
            return null;
        }
    }

    public static String fromUUID(UUID value) {
        return value.toString().replace("-", "");
    }

    public static enum AuthlibField {
        PROPERTY_VALUE_FIELD(Property.class, "value"),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_ID(MinecraftProfilePropertiesResponse.class, "id"),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_NAME(MinecraftProfilePropertiesResponse.class, "name"),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_PROPERTIES(MinecraftProfilePropertiesResponse.class, "properties"),
        MINECRAFT_TEXTURES_PAYLOAD_TEXTURES(MinecraftTexturesPayload.class, "textures");

        private final Field field;

        private AuthlibField(Class<?> clazz, String name) {
            try {
                this.field = clazz.getDeclaredField(name);
                this.field.setAccessible(true);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public <T> T get(Object o) {
            try {
                return (T)this.field.get(o);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

