/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.CustomSkinLoader;
import customskinloader.profile.CachedProfile;
import customskinloader.profile.UserProfile;
import customskinloader.utils.TimeUtil;
import java.io.File;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;

public class ProfileCache {
    public static File PROFILE_CACHE_DIR = new File(CustomSkinLoader.DATA_DIR, "ProfileCache");
    private Map<String, CachedProfile> cachedProfiles = new ConcurrentHashMap<String, CachedProfile>();
    private Map<String, UserProfile> localProfiles = new ConcurrentHashMap<String, UserProfile>();
    private Map<String, Deque<Function<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>, ?>>> profileLoaders = new ConcurrentHashMap();

    public ProfileCache() {
        if (!PROFILE_CACHE_DIR.exists()) {
            PROFILE_CACHE_DIR.mkdir();
        }
    }

    public boolean isExist(String username) {
        return this.cachedProfiles.containsKey(username.toLowerCase());
    }

    public boolean isLoading(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        return cp != null && cp.loading;
    }

    public boolean isReady(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        return cp != null && (cp.loading || cp.expiryTime > TimeUtil.getCurrentUnixTimestamp());
    }

    public boolean isExpired(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        return cp == null || cp.expiryTime <= TimeUtil.getCurrentUnixTimestamp();
    }

    public UserProfile getProfile(String username) {
        return this.getCachedProfile((String)username).profile;
    }

    public long getExpiry(String username) {
        return this.getCachedProfile((String)username).expiryTime;
    }

    public UserProfile getLocalProfile(String username) {
        if (this.localProfiles.containsKey(username.toLowerCase())) {
            return this.localProfiles.get(username.toLowerCase());
        }
        return this.loadLocalProfile(username);
    }

    public Function<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>, ?> getLastLoader(String username) {
        Deque<Function<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>, ?>> deque = this.profileLoaders.get(username);
        if (deque != null) {
            return deque.pollLast();
        }
        return null;
    }

    public void setLoading(String username, boolean loading) {
        this.getCachedProfile((String)username).loading = loading;
    }

    public void updateCache(String username, UserProfile profile) {
        this.updateCache(username, profile, CustomSkinLoader.config.enableLocalProfileCache);
    }

    public void updateCache(String username, UserProfile profile, boolean saveLocalProfile) {
        CachedProfile cp = this.getCachedProfile(username);
        cp.profile = profile;
        cp.expiryTime = TimeUtil.getUnixTimestamp(CustomSkinLoader.config.cacheExpiry);
        if (!saveLocalProfile) {
            return;
        }
        this.saveLocalProfile(username, profile);
    }

    public void putLoader(String username, Function<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>, ?> loader) {
        this.profileLoaders.putIfAbsent(username, new ConcurrentLinkedDeque());
        this.profileLoaders.get(username).offerLast(loader);
    }

    private CachedProfile getCachedProfile(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        if (cp != null) {
            return cp;
        }
        cp = new CachedProfile();
        this.cachedProfiles.put(username.toLowerCase(), cp);
        return cp;
    }

    private UserProfile loadLocalProfile(String username) {
        File localProfile = new File(PROFILE_CACHE_DIR, username.toLowerCase() + ".json");
        if (!localProfile.exists()) {
            this.localProfiles.put(username.toLowerCase(), null);
        }
        try {
            String json = FileUtils.readFileToString((File)localProfile, (String)"UTF-8");
            UserProfile profile = (UserProfile)CustomSkinLoader.GSON.fromJson(json, UserProfile.class);
            this.localProfiles.put(username.toLowerCase(), profile);
            CustomSkinLoader.logger.info("Successfully load LocalProfile.");
            return profile;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to load LocalProfile.(" + e.toString() + ")");
            this.localProfiles.put(username.toLowerCase(), null);
            return null;
        }
    }

    private void saveLocalProfile(String username, UserProfile profile) {
        String json = CustomSkinLoader.GSON.toJson((Object)profile);
        File localProfile = new File(PROFILE_CACHE_DIR, username + ".json");
        if (localProfile.exists()) {
            localProfile.delete();
        }
        try {
            FileUtils.write((File)localProfile, (CharSequence)json, (String)"UTF-8");
            CustomSkinLoader.logger.info("Successfully save LocalProfile.");
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to save LocalProfile.(" + e.toString() + ")");
        }
    }
}

