/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UUIDTypeAdapter;
import customskinloader.CustomSkinLoader;
import customskinloader.profile.ModelManager0;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.HttpUtil0;
import customskinloader.utils.TextureUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DynamicSkullManager {
    private Map<GameProfile, SkullTexture> dynamicTextures = new ConcurrentHashMap<GameProfile, SkullTexture>();
    private Map<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>> staticTextures = new ConcurrentHashMap<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>();
    private List<GameProfile> loadingList = Lists.newArrayList();

    private void parseGameProfile(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            this.staticTextures.put(profile, Maps.newHashMap());
            return;
        }
        String value = (String)TextureUtil.AuthlibField.PROPERTY_VALUE_FIELD.get(textureProperty);
        if (StringUtils.isBlank((CharSequence)value)) {
            this.staticTextures.put(profile, Maps.newHashMap());
            return;
        }
        String json = new String(Base64.decodeBase64((String)value), Charsets.UTF_8);
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
        SkullTexture result = (SkullTexture)gson.fromJson(json, SkullTexture.class);
        if (result == null) {
            this.staticTextures.put(profile, Maps.newHashMap());
            return;
        }
        this.staticTextures.put(profile, (Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>)(result.textures == null || !result.textures.containsKey(MinecraftProfileTexture.Type.SKIN) ? Maps.newHashMap() : this.parseTextures(result.textures)));
        if (StringUtils.isNotEmpty((CharSequence)result.index)) {
            File indexFile = new File(CustomSkinLoader.DATA_DIR, result.index);
            try {
                Object[] skins;
                String index = FileUtils.readFileToString((File)indexFile, (String)"UTF-8");
                if (StringUtils.isNotEmpty((CharSequence)index) && (skins = (String[])CustomSkinLoader.GSON.fromJson(index, String[].class)) != null && skins.length != 0) {
                    result.skins = Lists.newArrayList((Object[])skins);
                }
            }
            catch (Exception e) {
                CustomSkinLoader.logger.warning("Exception occurs while parsing index file: " + e.toString());
            }
        }
        if (!CustomSkinLoader.config.enableDynamicSkull || result.skins == null || result.skins.isEmpty()) {
            return;
        }
        CustomSkinLoader.logger.info("Try to load Dynamic Skull: " + json);
        for (int i = 0; i < result.skins.size(); ++i) {
            String skin = result.skins.get(i);
            if (HttpUtil0.isLocal(skin)) {
                File skinFile = new File(CustomSkinLoader.DATA_DIR, skin);
                if (skinFile.isFile() && skinFile.length() > 0L) {
                    String fakeUrl = HttpTextureUtil.getLocalFakeUrl(skin);
                    result.skins.set(i, fakeUrl);
                    continue;
                }
                result.skins.remove(i--);
                continue;
            }
            HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(skin).setCacheFile(HttpTextureUtil.getCacheFile(FilenameUtils.getBaseName((String)skin))).setCacheTime(0).setLoadContent(false));
            if (responce.success) continue;
            result.skins.remove(i--);
        }
        if (result.skins.isEmpty()) {
            CustomSkinLoader.logger.info("Failed: Nothing loaded.");
            return;
        }
        result.interval = Math.max(result.interval, 50);
        if (result.fromZero) {
            result.startTime = System.currentTimeMillis();
        }
        result.period = result.interval * result.skins.size();
        CustomSkinLoader.logger.info("Successfully loaded Dynamic Skull: " + new Gson().toJson((Object)result));
        this.dynamicTextures.put(profile, result);
        this.staticTextures.remove(profile);
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> parseTextures(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
        MinecraftProfileTexture skin = textures.get(MinecraftProfileTexture.Type.SKIN);
        String skinUrl = skin.getUrl();
        if (!HttpUtil0.isLocal(skinUrl)) {
            return textures;
        }
        File skinFile = new File(CustomSkinLoader.DATA_DIR, skinUrl);
        if (!skinFile.isFile()) {
            return Maps.newHashMap();
        }
        textures.put(MinecraftProfileTexture.Type.SKIN, ModelManager0.getProfileTexture(HttpTextureUtil.getLocalFakeUrl(skinUrl), null));
        return textures;
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTexture(GameProfile profile) {
        if (this.staticTextures.get(profile) != null) {
            return this.staticTextures.get(profile);
        }
        if (this.loadingList.contains(profile)) {
            return Maps.newHashMap();
        }
        if (this.dynamicTextures.containsKey(profile)) {
            SkullTexture texture = this.dynamicTextures.get(profile);
            long time = System.currentTimeMillis() - texture.startTime;
            int index = (int)Math.floor(time % (long)texture.period / (long)texture.interval);
            HashMap map = Maps.newHashMap();
            map.put(MinecraftProfileTexture.Type.SKIN, ModelManager0.getProfileTexture(texture.skins.get(index), null));
            return map;
        }
        this.loadingList.add(profile);
        Thread loadThread = new Thread(() -> {
            this.parseGameProfile(profile);
            this.loadingList.remove(profile);
        });
        loadThread.setName("Skull " + profile.hashCode());
        loadThread.start();
        return Maps.newHashMap();
    }

    public static class SkullTexture {
        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures;
        public String index;
        public ArrayList<String> skins;
        public int interval;
        public boolean fromZero;
        public long startTime;
        public int period;
    }
}

