/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.platform.NativeImage;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.IFakeImageBuffer;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;

public class FakeSkinManager {
    private static final Map<ResourceLocation, MinecraftProfileTexture> MODEL_CACHE = new ConcurrentHashMap<ResourceLocation, MinecraftProfileTexture>();
    private static CacheLoader<Object, ?> cacheLoader;
    private static final String KEY = "CustomSkinLoaderInfo";
    private static final String SKULL_KEY = "CSL$IsSkull";

    public static void setSkinCacheDir(File skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public static void setSkinCacheDir(Path skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory.toFile();
    }

    public static CacheLoader<Object, ?> setCacheLoader(CacheLoader<Object, ?> loader) {
        cacheLoader = loader;
        return cacheLoader;
    }

    public static Object loadCache(LoadingCache<?, ?> loadingCache, Object cacheKey) throws Exception {
        return cacheLoader.load(cacheKey);
    }

    public static ResourceLocation setResourceLocation(ResourceLocation resourceLocation, MinecraftProfileTexture profileTexture) {
        if (profileTexture instanceof FakeMinecraftProfileTexture) {
            ((FakeMinecraftProfileTexture)profileTexture).setResourceLocation(resourceLocation);
        }
        return resourceLocation;
    }

    public static MinecraftProfileTexture getModelCache(MinecraftProfileTexture profileTexture, ResourceLocation location) {
        return MODEL_CACHE.getOrDefault(location, profileTexture);
    }

    public static Object[] createThreadDownloadImageData(ImmutableList<Object> list, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        Object[] params = list.toArray();
        if (profileTexture instanceof FakeMinecraftProfileTexture && params.length > 1) {
            FakeMinecraftProfileTexture fakeProfileTexture = (FakeMinecraftProfileTexture)profileTexture;
            ResourceLocation resourcelocation = fakeProfileTexture.getResourceLocation();
            if (fakeProfileTexture.getResourceLocation() != null) {
                params[0] = fakeProfileTexture.getCacheFile();
                if (params[params.length - 2] instanceof Boolean) {
                    params[params.length - 2] = true;
                }
                params[params.length - 1] = new BaseBuffer((Runnable)params[params.length - 1], textureType, resourcelocation, fakeProfileTexture);
            }
        }
        return params;
    }

    public static void loadProfileTextures(Runnable runnable, GameProfile profile) {
        CustomSkinLoader.loadProfileTextures(() -> CustomSkinLoader.loadProfileLazily(profile, m -> {
            profile.getProperties().put((Object)KEY, m);
            runnable.run();
            return null;
        }));
    }

    public static Object[] loadProfileTextures(ImmutableList<Object> list, GameProfile profile) {
        Object[] params = list.toArray();
        if (!profile.getProperties().containsKey((Object)SKULL_KEY)) {
            Supplier supplier = (Supplier)params[0];
            params[0] = () -> FakeSkinManager.lambda$loadProfileTextures$3(profile, (Supplier)supplier);
            params[1] = CustomSkinLoader.THREAD_POOL;
        } else {
            params[1] = Minecraft.m_91087_();
        }
        return params;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getUserProfile(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return profile.getProperties().removeAll((Object)KEY).stream().findFirst().orElse(Maps.newHashMap());
    }

    public static void loadElytraTexture(SkinManager skinManager, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, SkinManager.SkinTextureCallback skinAvailableCallback) {
        for (int i = 2; i < MinecraftProfileTexture.Type.values().length; ++i) {
            MinecraftProfileTexture.Type type = MinecraftProfileTexture.Type.values()[i];
            if (!map.containsKey(type)) continue;
            skinManager.loadSkin(map.get(type), type, skinAvailableCallback);
        }
    }

    public static void setSkullType(GameProfile profile) {
        profile.getProperties().removeAll((Object)SKULL_KEY);
        profile.getProperties().put((Object)SKULL_KEY, (Object)new Property(SKULL_KEY, "true"));
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        if (profile.getProperties().containsKey((Object)SKULL_KEY)) {
            profile.getProperties().removeAll((Object)SKULL_KEY);
            return CustomSkinLoader.loadProfileFromCache(profile);
        }
        return FakeSkinManager.getUserProfile(sessionService, profile, requireSecure);
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    private static boolean shouldJudgeType(MinecraftProfileTexture texture) {
        return texture != null && "auto".equals(texture.getMetadata("model"));
    }

    private static /* synthetic */ Object lambda$loadProfileTextures$3(GameProfile profile, Supplier supplier) {
        return CustomSkinLoader.loadProfileLazily(profile, arg_0 -> FakeSkinManager.lambda$null$2(profile, (Supplier)supplier, arg_0));
    }

    private static /* synthetic */ Object lambda$null$2(GameProfile profile, Supplier supplier, Map m) {
        profile.getProperties().put((Object)KEY, (Object)m);
        return supplier.get();
    }

    private static class BaseBuffer
    implements IFakeImageBuffer {
        private IFakeImageBuffer buffer;
        private final Runnable callback;
        private final ResourceLocation location;
        private final FakeMinecraftProfileTexture texture;

        public BaseBuffer(Runnable callback, MinecraftProfileTexture.Type type, ResourceLocation location, FakeMinecraftProfileTexture texture) {
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer(location);
                }
            }
            this.callback = callback;
            this.location = location;
            this.texture = texture;
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        @Override
        public BufferedImage parseUserSkin(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).parseUserSkin(image) : image;
        }

        @Override
        public void skinAvailable() {
            if (this.buffer != null) {
                this.buffer.skinAvailable();
                if (FakeSkinManager.shouldJudgeType(this.texture) && this.buffer instanceof FakeSkinBuffer) {
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    this.texture.setModule(type);
                    MODEL_CACHE.put(this.location, this.texture);
                }
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

