/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.item.IMultiModeItem;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RSASounds;
import cofh.redstonearsenal.item.IFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface IMultiModeFluxItem
extends IFluxItem,
IMultiModeItem {
    default public boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) > 0;
    }

    default public float getEmpoweredModelProperty(ItemStack stack, Level world, LivingEntity entity, int seed) {
        return this.hasEnergy(stack, false) && this.isEmpowered(stack) ? 1.0f : 0.0f;
    }

    default public void onModeChange(Player player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)RSASounds.SOUND_EMPOWER.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        } else {
            player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)RSASounds.SOUND_QUELL.get(), SoundSource.PLAYERS, 0.2f, 0.6f);
        }
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.redstone_arsenal.mode." + this.getMode(stack)));
    }

    @Override
    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    @Override
    default public void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.isEmpowered(stack)) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.1").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.0").m_130940_(ChatFormatting.GRAY));
        }
        if (this.getNumModes(stack) > 1) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
        IFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }
}

