/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.wire;

import com.dugkse.moderntrainparts.config.ModernTrainPartsServerConfig;
import com.dugkse.moderntrainparts.content.wire.WireBlock;
import com.dugkse.moderntrainparts.content.wire.WireBlockEntity;
import com.dugkse.moderntrainparts.init.MTPBlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WireConnectorItem
extends Item {
    public WireConnectorItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player playerEntity = context.m_43723_();
        Level world = context.m_43725_();
        if (playerEntity != null && playerEntity.m_6144_()) {
            context.m_43722_().m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        boolean validAxis = WireConnectorItem.validateAxis(world, pos);
        if (world.f_46443_) {
            return validAxis ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        CompoundTag tag = context.m_43722_().m_41784_();
        BlockPos firstPulley = null;
        if (!(!tag.m_128441_("FirstPulley") || WireConnectorItem.validateAxis(world, firstPulley = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstPulley"))) && firstPulley.m_123314_((Vec3i)pos, (double)(WireConnectorItem.maxLength() * 2)))) {
            tag.m_128473_("FirstPulley");
            context.m_43722_().m_41751_(tag);
        }
        if (!validAxis || playerEntity == null) {
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("FirstPulley")) {
            if (!WireConnectorItem.canConnect(world, firstPulley, pos)) {
                return InteractionResult.FAIL;
            }
            if (firstPulley != null && !firstPulley.equals((Object)pos)) {
                WireConnectorItem.createBelts(world, firstPulley, pos, playerEntity, Direction.m_122402_((String)tag.m_128469_("FirstPulley").m_128461_("ClickedFace")), context.m_43719_());
                if (!playerEntity.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
            if (!context.m_43722_().m_41619_()) {
                context.m_43722_().m_41751_(null);
                playerEntity.m_36335_().m_41524_((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        CompoundTag compoundTag = NbtUtils.m_129224_((BlockPos)pos);
        compoundTag.m_128359_("ClickedFace", context.m_43719_().m_122433_());
        tag.m_128365_("FirstPulley", (Tag)compoundTag);
        context.m_43722_().m_41751_(tag);
        playerEntity.m_36335_().m_41524_((Item)this, 5);
        return InteractionResult.SUCCESS;
    }

    public static boolean canConnect(Level world, BlockPos first, BlockPos second) {
        if (!WireConnectorItem.validateAxis(world, first)) {
            return false;
        }
        if (!WireConnectorItem.validateAxis(world, second)) {
            return false;
        }
        if (!second.m_123314_((Vec3i)first, (double)WireConnectorItem.maxLength().intValue())) {
            return false;
        }
        return !(world.m_8055_(first).m_60734_() instanceof WireBlock) || !(world.m_8055_(second).m_60734_() instanceof WireBlock);
    }

    public static Integer maxLength() {
        return (Integer)ModernTrainPartsServerConfig.WIRE_LENGTH.get();
    }

    public static boolean validateAxis(Level world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        return world.m_8055_(pos).m_60734_() instanceof WireBlock || world.m_8055_(pos.m_7494_()).m_60734_() instanceof AirBlock;
    }

    public static void createBelts(Level world, BlockPos start, BlockPos end, Player plr, Direction startFace, Direction endFace) {
        if (world.m_8055_(start).m_60734_() instanceof WireBlock) {
            BlockPos t = start.m_7495_();
            start = end.m_7494_();
            end = t;
        } else {
            start = start.m_142300_(startFace);
        }
        System.out.println(endFace);
        if (!(world.m_8055_(end).m_60734_() instanceof WireBlock)) {
            end = end.m_142300_(endFace);
        }
        Vec3 startVector = new Vec3((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_());
        Vec3 endVector = new Vec3((double)end.m_123341_(), (double)end.m_123342_(), (double)end.m_123343_());
        double run = Math.sqrt((endVector.f_82479_ - startVector.f_82479_) * (endVector.f_82479_ - startVector.f_82479_) + (endVector.f_82481_ - startVector.f_82481_) * (endVector.f_82481_ - startVector.f_82481_));
        double rise = endVector.f_82480_ - startVector.f_82480_;
        int horizontal_angle = WireConnectorItem.angleFromVectors(startVector.f_82479_, endVector.f_82479_, startVector.f_82481_, endVector.f_82481_);
        int vertical_angle = -WireConnectorItem.angleFromSlope(rise / run);
        int horizontal_direction = horizontal_angle / 45;
        horizontal_angle -= horizontal_direction * 45;
        int vertical_direction = 0;
        world.m_46597_(start, MTPBlockInit.WIRE_BLOCK.getDefaultState());
        BlockEntity entity = world.m_7702_(start);
        world.m_142346_((Entity)plr, GameEvent.f_157797_, start);
        world.m_5594_(null, start, SoundEvents.f_144119_, SoundSource.BLOCKS, 0.75f, 1.0f);
        if (entity instanceof WireBlockEntity) {
            WireBlockEntity wBE = (WireBlockEntity)entity;
            wBE.setLength((int)(startVector.m_82554_(endVector) * 100.0));
            wBE.setHorizontalOrientation(horizontal_angle);
            wBE.setHorizontalDirection(horizontal_direction);
            wBE.setVerticalOrientation(vertical_angle);
            wBE.setVerticalDirection(vertical_direction);
            wBE.end_position = end.m_141950_((Vec3i)start);
        }
    }

    private static int angleFromVectors(double x1, double x2, double z1, double z2) {
        double angle = Math.atan2(z2 - z1, x2 - x1);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return (int)Math.round(angle * 57.29577951308232);
    }

    private static int angleFromSlope(double slope) {
        double angle = Math.atan(slope);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return (int)Math.round(angle * 57.29577951308232);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("FirstPulley");
    }
}

