/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.gui.element;

import com.mikitellurium.turtlecharginstation.block.blockentity.custom.TurtleChargingStationBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TurtleInfoElement
extends GuiComponent {
    private final TurtleChargingStationBlockEntity charger;
    private Rect2i area;
    private final int width = 100;
    private final int height = 80;
    private final Font font;
    private final int white;

    public TurtleInfoElement(TurtleChargingStationBlockEntity charger, int xPos, int yPos) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.white = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        this.area = new Rect2i(xPos, yPos, 100, 80);
        this.charger = charger;
    }

    public void draw(PoseStack poseStack) {
        int x = this.area.m_110085_();
        int y = this.area.m_110086_();
        TurtleInfoElement.m_93208_((PoseStack)poseStack, (Font)this.font, (String)"Name", (int)(x + 55), (int)(y + 1), (int)this.white);
        TurtleInfoElement.m_93236_((PoseStack)poseStack, (Font)this.font, (String)"Fuel Level", (int)(x + this.area.m_110090_() - 14), (int)(y + 1), (int)this.white);
        int h = y;
        for (Direction direction : Direction.values()) {
            TurtleInfoElement.m_93236_((PoseStack)poseStack, (Font)this.font, (String)this.getDirectionString(direction), (int)this.alignString(this.getDirectionString(direction), x), (int)(h += 12), (int)this.white);
            TurtleInfoElement.m_93208_((PoseStack)poseStack, (Font)this.font, (String)TurtleData.getAdjacentTurtleName(this.charger, direction), (int)(x + 55), (int)h, (int)TurtleData.getAdjacentTurtleColor(this.charger, direction));
            TurtleInfoElement.m_93208_((PoseStack)poseStack, (Font)this.font, (String)this.getFuelString(TurtleData.getAdjacentTurtleFuel(this.charger, direction)), (int)(x + 110), (int)h, (int)this.white);
        }
    }

    private String getDirectionString(Direction direction) {
        switch (direction.m_122433_()) {
            case "down": {
                return " Down:";
            }
            case "up": {
                return "   Up:";
            }
            case "north": {
                return "North:";
            }
            case "south": {
                return "South:";
            }
            case "west": {
                return " West:";
            }
            case "east": {
                return " East:";
            }
        }
        return "-";
    }

    private String getFuelString(int fuelLevel) {
        if (fuelLevel == -1) {
            return "-";
        }
        return String.valueOf(fuelLevel);
    }

    private int alignString(String string, int xPos) {
        if (Objects.equals(string, "   Up:")) {
            return xPos + 4;
        }
        if (Objects.equals(string, " West:") || Objects.equals(string, " East:")) {
            return xPos + 2;
        }
        return xPos;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public static class TurtleData {
        private static final int white = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);

        public static String getAdjacentTurtleName(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_142300_(direction));
            if (be == null) {
                return "-";
            }
            if (be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_ADVANCED.get()) {
                TileTurtle turtle = (TileTurtle)be;
                if (turtle.m_8077_()) {
                    return turtle.getLabel();
                }
                return String.valueOf(turtle.getComputerID());
            }
            return "-";
        }

        public static int getAdjacentTurtleColor(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_142300_(direction));
            if (be == null) {
                return white;
            }
            if (be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_ADVANCED.get()) {
                TileTurtle turtle = (TileTurtle)be;
                if (turtle.getColour() == -1) {
                    return white;
                }
                return turtle.getColour();
            }
            return white;
        }

        public static int getAdjacentTurtleFuel(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_142300_(direction));
            if (be == null) {
                return -1;
            }
            if (be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_ADVANCED.get()) {
                TileTurtle turtle = (TileTurtle)be;
                return turtle.getAccess().getFuelLevel();
            }
            return -1;
        }
    }
}

