/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.common.NameHelper;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ChestInfoHelper {
    private static final Style GOLD = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GREEN = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true));
    private static final TextComponent DUMMY = new TextComponent("");

    public static void getHUDInfo(List<MutableComponent> tooltip, String ownerName, String code) {
        tooltip.add(ChestInfoHelper.infoChestOwner(ownerName, true));
        tooltip.add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("info.enderchests.chest.code")).m_7220_((Component)new TextComponent(" " + code)));
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderChest chestTile) {
        ChestInfoHelper.sendInfo(player, new TranslatableComponent("info.enderchests.chest.capacity").m_130946_(" " + ChestHelper.getCapacity(player.m_20193_(), chestTile.getOwnerID(), chestTile.getCode())));
    }

    public static void sendLinkError(Player player, int error) {
        ChestInfoHelper.sendInfo(player, new TranslatableComponent("error.enderchests.bag.nolink" + error).m_6270_(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        ChestInfoHelper.sendInfo(player, new TranslatableComponent("error." + error).m_6270_(BOLD_RED));
    }

    public static MutableComponent infoChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                return new TextComponent(" [-").m_6270_(GOLD).m_7220_((Component)new TranslatableComponent("info.enderchests.chest.public")).m_7220_((Component)new TextComponent("-]"));
            }
            return DUMMY;
        }
        if (owner.startsWith("#")) {
            return new TextComponent(" [-" + owner.substring(1) + "-]").m_6270_(GREEN);
        }
        return new TextComponent(" [-" + owner + "-]").m_6270_(AQUA);
    }

    @Nullable
    public static MutableComponent formatChestOwner(String owner) {
        MutableComponent component = ChestInfoHelper.infoChestOwner(owner, false);
        return component != DUMMY ? component : null;
    }

    public static void sendInfo(Player player, MutableComponent message) {
        if (player != null) {
            player.m_5661_((Component)message, true);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

