/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerEnderChest
extends AbstractContainerMenu {
    private TileEntityEnderChest chestTile;
    private InventoryInternal chest;
    private MutableComponent owner;
    private final DataSlot size = DataSlot.m_39401_();
    private Runnable callbackInventoryChange;

    public ContainerEnderChest(int id, Inventory invPlayer, TileEntityEnderChest tile) {
        super(Values.Container.ENDER_CHEST, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, tile.getChest(), tile.getOwnerName());
        this.chestTile = tile;
        this.chestTile.onContainerOpen((BlockEntity)this.chestTile, (Container)this.chest, invPlayer.f_35978_);
    }

    public ContainerEnderChest(int id, Inventory invPlayer, InventoryInternal chest, String owner) {
        super(Values.Container.ENDER_BAG, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, chest, owner);
    }

    private void common_setup(Inventory invPlayer, InventoryInternal chest, String owner) {
        int slotId;
        this.chest = chest;
        this.owner = ChestInfoHelper.infoChestOwner(owner, true);
        for (slotId = 0; slotId < 54; ++slotId) {
            this.m_38897_(new Slots.Hideable((Container)chest, slotId, 0, 0));
        }
        for (slotId = 0; slotId < 27; ++slotId) {
            this.m_38897_(new Slot((Container)invPlayer, slotId + 9, 0, 0));
        }
        for (slotId = 0; slotId < 9; ++slotId) {
            this.m_38897_(new Slot((Container)invPlayer, slotId, 0, 0));
        }
        this.m_38895_(this.size).m_6422_(this.chest.m_6643_());
    }

    public void m_38946_() {
        this.size.m_6422_(this.chest.m_6643_());
        super.m_38946_();
    }

    public boolean isParentTile(TileEntityEnderChest tile) {
        return this.chestTile == tile;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7511_(int id, int value) {
        super.m_7511_(id, value);
        if (this.size.m_6501_() != this.chest.m_6643_()) {
            Component text = this.chest.m_7755_();
            String name = text instanceof TranslatableComponent ? ((TranslatableComponent)text).m_131328_() : text.m_6111_();
            String[] parts = name.split("\\.");
            if (parts.length == 2) {
                ChestHelper.setCapacity((Level)Minecraft.m_91087_().f_91073_, parts[0], parts[1], (byte)value);
                this.callbackInventoryChange.run();
            } else if (parts.length == 4) {
                ChestHelper.setCapacity((Level)Minecraft.m_91087_().f_91073_, parts[2], parts[3], (byte)value);
                this.callbackInventoryChange.run();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType >= 0 && dragType < 9 && !(stack = player.m_150109_().m_8020_(dragType)).m_41619_() && stack.m_41720_() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.chestTile != null) {
            this.chestTile.onContainerClosed((BlockEntity)this.chestTile, (Container)this.chest, player);
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slotNumber) {
        Slot clickedSlot = (Slot)this.f_38839_.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemInSlot = clickedSlot.m_7993_();
        if (itemInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack returnStack = itemInSlot.m_41777_();
        if (slotNumber < 54 ? !this.m_38903_(itemInSlot, 54, this.f_38839_.size(), true) : !this.m_38903_(itemInSlot, 0, this.chest.m_6643_(), false)) {
            return ItemStack.f_41583_;
        }
        if (itemInSlot.m_41613_() == 0) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        if (itemInSlot.m_41613_() == returnStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return returnStack;
    }

    public int getChestSize() {
        return this.chest.m_6643_();
    }

    public MutableComponent getOwner() {
        return this.owner;
    }
}

