/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessUpgradeRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

@IRecipeHandler.For(value=UpgradeRecipe.class)
public final class SmithingRecipeHandler
implements IRecipeHandler<UpgradeRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, UpgradeRecipe recipe) {
        return String.format("smithing.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IIngredient.fromIngredient(((AccessUpgradeRecipe)recipe).crafttweaker$getBase()).getCommandString(), IIngredient.fromIngredient(((AccessUpgradeRecipe)recipe).crafttweaker$getAddition()).getCommandString());
    }

    @Override
    public Optional<Function<ResourceLocation, UpgradeRecipe>> replaceIngredients(IRecipeManager manager, UpgradeRecipe recipe, List<IReplacementRule> rules) {
        Optional<Ingredient> base = IRecipeHandler.attemptReplacing(((AccessUpgradeRecipe)recipe).crafttweaker$getBase(), Ingredient.class, recipe, rules);
        Optional<Ingredient> addition = IRecipeHandler.attemptReplacing(((AccessUpgradeRecipe)recipe).crafttweaker$getAddition(), Ingredient.class, recipe, rules);
        if (!base.isPresent() && !addition.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(id -> new UpgradeRecipe(id, base.orElseGet(() -> ((AccessUpgradeRecipe)recipe).crafttweaker$getBase()), addition.orElseGet(() -> ((AccessUpgradeRecipe)recipe).crafttweaker$getAddition()), recipe.m_8043_()));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, UpgradeRecipe firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof UpgradeRecipe)) {
            return this.redirectNonVanilla(manager, secondRecipe, firstRecipe);
        }
        UpgradeRecipe second = (UpgradeRecipe)secondRecipe;
        return IngredientUtil.canConflict(((AccessUpgradeRecipe)firstRecipe).crafttweaker$getBase(), ((AccessUpgradeRecipe)second).crafttweaker$getBase()) && IngredientUtil.canConflict(((AccessUpgradeRecipe)firstRecipe).crafttweaker$getAddition(), ((AccessUpgradeRecipe)second).crafttweaker$getAddition());
    }

    private <T extends Recipe<?>> boolean redirectNonVanilla(IRecipeManager manager, T second, UpgradeRecipe first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict(manager, second, first);
    }
}

