/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.impl.command.CommandImpl;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public final class HelpCommand {
    private static final int COMMANDS_PER_PAGE = 4;

    private HelpCommand() {
    }

    public static void registerCommandIfRequired(CtCommands instance) {
        Map<String, CommandImpl> commands = instance.commands();
        if (commands.containsKey("help")) {
            return;
        }
        instance.registerCommand("help", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.help"), builder -> {
            builder.executes(context -> HelpCommand.executeHelp(commands, (CommandContext<CommandSourceStack>)context, 1));
            builder.then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> HelpCommand.executeHelp(commands, (CommandContext<CommandSourceStack>)context, (Integer)context.getArgument("page", Integer.TYPE))));
        });
    }

    private static int executeHelp(Map<String, CommandImpl> commands, CommandContext<CommandSourceStack> context, int currentPage) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<String> allowedToUseCommands = commands.keySet().stream().filter(s -> ((CommandImpl)commands.get(s)).requirement().test(source)).toList();
        int maxPages = (int)Math.ceil((double)allowedToUseCommands.size() / 4.0);
        int clampedPage = Mth.m_14045_((int)currentPage, (int)1, (int)maxPages);
        int minIndex = (clampedPage - 1) * 4;
        int maxIndex = Math.min(commands.size(), minIndex + 4);
        for (int i = minIndex; i < maxIndex; ++i) {
            CommandImpl command = commands.get(allowedToUseCommands.get(i));
            String commandStr = "/ct " + command.name();
            source.m_81354_(CommandUtilities.run((MutableComponent)new TextComponent(commandStr), commandStr), true);
            source.m_81354_((Component)new TextComponent("- ").m_7220_((Component)command.description().m_130940_(ChatFormatting.DARK_AQUA)), true);
        }
        source.m_81354_((Component)new TranslatableComponent("crafttweaker.command.help.page.info", new Object[]{clampedPage, maxPages}), true);
        return 1;
    }
}

