/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class IngredientReplacementRule
implements IReplacementRule {
    private final IIngredient from;
    private final IIngredient to;

    private IngredientReplacementRule(IIngredient from, IIngredient to) {
        this.from = from;
        this.to = to;
    }

    public static IReplacementRule create(IIngredient from, IIngredient to) {
        return IngredientReplacementRule.areTheSame(from, to) ? IReplacementRule.EMPTY : new IngredientReplacementRule(from, to);
    }

    private static boolean areTheSame(IIngredient a, IIngredient b) {
        return a == b || Objects.equals(a, b) || a.contains(b) && b.contains(a);
    }

    @Override
    public <T, U extends Recipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
        return IReplacementRule.chain(IReplacementRule.withType(ingredient, type, recipe, IIngredient.class, this::getIIngredientReplacement), IReplacementRule.withType(ingredient, type, recipe, Ingredient.class, this::getIngredientReplacement));
    }

    private <U extends Recipe<?>> Optional<IIngredient> getIIngredientReplacement(IIngredient original, U recipe) {
        Object[] newItems;
        Object[] oldItems = original.getItems();
        return Arrays.equals(oldItems, newItems = (IIngredient[])Arrays.stream(oldItems).map(this::getStackReplacement).toArray(IIngredient[]::new)) ? Optional.empty() : Optional.of(new IIngredientList((IIngredient[])newItems));
    }

    private <U extends Recipe<?>> Optional<Ingredient> getIngredientReplacement(Ingredient original, U recipe) {
        return this.getIIngredientReplacement(IIngredient.fromIngredient(original), recipe).map(IIngredient::asVanillaIngredient);
    }

    private IIngredient getStackReplacement(IItemStack original) {
        return this.from.matches(original) ? this.to : original;
    }

    @Override
    public String describe() {
        return String.format("Replacing %s --> %s", this.from.getCommandString(), this.to.getCommandString());
    }
}

