/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.command.argument.IItemStackArgument;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.logger.CraftTweakerLogger;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.blamejared.crafttweaker.impl.plugin.core.PluginManager;
import com.blamejared.crafttweaker.platform.Services;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftTweakerCommon {
    public static final Logger LOG = LogManager.getLogger((String)"CraftTweaker");
    private static Set<String> PATRON_LIST = new HashSet<String>();
    private static final Supplier<PluginManager> PLUGIN_MANAGER = Suppliers.memoize(PluginManager::of);

    public static void init() {
        try {
            Files.createDirectories(CraftTweakerAPI.getScriptsDirectory(), new FileAttribute[0]);
        }
        catch (IOException e) {
            String path = CraftTweakerAPI.getScriptsDirectory().toAbsolutePath().toString();
            throw new IllegalStateException("Could not create Directory " + path);
        }
        CraftTweakerLogger.init();
        Services.REGISTRY.init();
        new Thread(() -> {
            try {
                URL url = new URL("https://blamejared.com/patrons.txt");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(15000);
                urlConnection.setRequestProperty("User-Agent", "CraftTweaker|1.18.2");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                    PATRON_LIST = reader.lines().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static PluginManager getPluginManager() {
        return PLUGIN_MANAGER.get();
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        CtCommands.get().registerCommandsTo(dispatcher, environment);
    }

    public static void registerCommandArguments() {
        ArgumentTypes.m_121601_((String)"crafttweaker:recipe_type", RecipeTypeArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(RecipeTypeArgument::get));
        ArgumentTypes.m_121601_((String)"crafttweaker:item", IItemStackArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(IItemStackArgument::get));
    }

    public static Set<String> getPatronList() {
        return PATRON_LIST;
    }

    public static void loadInitScripts() {
        ScriptRunConfiguration configuration = new ScriptRunConfiguration("initialize", CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE);
        try {
            CraftTweakerAPI.getScriptRunManager().createScriptRun(configuration).execute();
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error("Unable to run init scripts due to an error", e);
        }
    }
}

