/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.gravestone.ClientConfig;
import de.maxhenkel.gravestone.ServerConfig;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.commands.RestoreCommand;
import de.maxhenkel.gravestone.corelib.CommonRegistry;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.entity.PlayerGhostRenderer;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.net.MessageOpenObituary;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.tileentity.render.GravestoneRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="gravestone")
@Mod(value="gravestone")
public class Main {
    public static final String MODID = "gravestone";
    public static final Logger LOGGER = LogManager.getLogger((String)"gravestone");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static GraveStoneBlock GRAVESTONE;
    public static Item GRAVESTONE_ITEM;
    public static BlockEntityType<GraveStoneTileEntity> GRAVESTONE_TILEENTITY;
    public static ObituaryItem OBITUARY;
    public static EntityType<GhostPlayerEntity> GHOST;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(BlockEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageOpenObituary.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(GRAVESTONE_TILEENTITY, GravestoneRenderer::new);
        EntityRenderers.m_174036_(GHOST, PlayerGhostRenderer::new);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        RestoreCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        GRAVESTONE = new GraveStoneBlock();
        blockArray[0] = GRAVESTONE;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[2];
        itemArray[0] = GRAVESTONE_ITEM = GRAVESTONE.toItem();
        OBITUARY = new ObituaryItem();
        itemArray[1] = OBITUARY;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        GRAVESTONE_TILEENTITY = BlockEntityType.Builder.m_155273_(GraveStoneTileEntity::new, (Block[])new Block[]{GRAVESTONE}).m_58966_(null);
        GRAVESTONE_TILEENTITY.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(GRAVESTONE_TILEENTITY);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        GHOST = CommonRegistry.registerEntity(MODID, "player_ghost", MobCategory.MONSTER, GhostPlayerEntity.class, builder -> builder.m_20699_(0.6f, 1.95f));
        event.getRegistry().register(GHOST);
    }

    @SubscribeEvent
    public void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(GHOST, GhostPlayerEntity.getGhostAttributes());
    }
}

