/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create;

import com.supermartijn642.rechiseled.api.ChiseledTextureProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public class WoodTextureProvider
extends ChiseledTextureProvider {
    private static final ResourceLocation ACACIA = new ResourceLocation("block/acacia_planks");
    private static final ResourceLocation BIRCH = new ResourceLocation("block/birch_planks");
    private static final ResourceLocation CRIMSON = new ResourceLocation("block/crimson_planks");
    private static final ResourceLocation DARK_OAK = new ResourceLocation("block/dark_oak_planks");
    private static final ResourceLocation JUNGLE = new ResourceLocation("block/jungle_planks");
    private static final ResourceLocation OAK = new ResourceLocation("block/oak_planks");
    private static final ResourceLocation SPRUCE = new ResourceLocation("block/spruce_planks");
    private static final ResourceLocation WARPED = new ResourceLocation("block/warped_planks");
    private static final List<ResourceLocation> PLANKS = Arrays.asList(ACACIA, BIRCH, CRIMSON, DARK_OAK, JUNGLE, OAK, SPRUCE, WARPED);

    public WoodTextureProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super("rechiseledcreate", generator, existingFileHelper);
    }

    protected void createTextures() {
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/acacia_window_bars_side"), ACACIA, "_window_bars_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_bars_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/birch_window_covered_side"), BIRCH, "_window_covered_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_covered_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/crimson_window_diagonal_side"), CRIMSON, "_window_diagonal_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_diagonal_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/dark_oak_window_large_side"), DARK_OAK, "_window_large_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_large_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/jungle_window_slim_side"), JUNGLE, "_window_slim_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_slim_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/oak_window_panes_side"), OAK, "_window_panes_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_panes_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/oak_window_tiles_side"), OAK, "_window_tiles_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_tiles_end", false);
        this.mapPlankTexture(new ResourceLocation("rechiseledcreate", "block/warped_window_swirling_side"), WARPED, "_window_swirling_side", true);
        this.mapPlankTexture(OAK, OAK, "_window_swirling_end", false);
    }

    private void mapPlankTexture(ResourceLocation texture, ResourceLocation base, String name, boolean ignoreSelf) {
        for (ResourceLocation plank : PLANKS) {
            if (ignoreSelf && plank == base) continue;
            String plankName = plank.m_135815_().substring("block/".length()).split("_planks")[0];
            this.createPaletteMap(base, plank).ignoreMissing().applyToTexture(texture, "block/" + plankName + name);
        }
    }
}

