/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.compat.jei.AnimatedDieselEngineElement;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Components;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class DieselEngineCategory
implements IRecipeCategory<DieselEngineJeiRecipeType> {
    IGuiHelper guiHelper;
    AnimatedDieselEngineElement engine = new AnimatedDieselEngineElement();

    public DieselEngineCategory(IGuiHelper helper) {
        this.guiHelper = helper;
    }

    public RecipeType<DieselEngineJeiRecipeType> getRecipeType() {
        return DieselEngineJeiRecipeType.DIESEL_BURNING;
    }

    public Component getTitle() {
        return CreateDieselGenerators.translate("createdieselgenerators.recipe.diesel_combustion", new Object[0]);
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 70);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)BlockRegistry.DIESEL_ENGINE.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DieselEngineJeiRecipeType recipe, IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, CreateRecipeCategory.withImprovedVisibility(recipe.fluids))).addTooltipCallback(CreateRecipeCategory.addFluidTooltip((int)1000));
    }

    public void draw(DieselEngineJeiRecipeType recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 40, 15);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 75, 40);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 28, 50);
        AllIcons.I_REFRESH.render(matrixStack, 145, 36);
        Minecraft.m_91087_().f_91062_.m_92889_(matrixStack, (Component)Components.literal((String)("\u00a7l" + recipe.speed + "rpm")), 80.0f, 32.0f, 0xEEEEEE);
        Minecraft.m_91087_().f_91062_.m_92889_(matrixStack, (Component)Components.literal((String)("\u00a7l" + recipe.stress + "su")), 80.0f, 49.0f, 0xEEEEEE);
        this.engine.draw(matrixStack, 47, 62);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("createdieselgenerators:diesel_burning");
    }

    public Class<? extends DieselEngineJeiRecipeType> getRecipeClass() {
        return DieselEngineJeiRecipeType.class;
    }
}

