/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge;

import agency.highlysuspect.packages.net.ActionPacket;
import agency.highlysuspect.packages.platform.CommonPlatformConfig;
import agency.highlysuspect.packages.platform.PlatformSupport;
import agency.highlysuspect.packages.platform.forge.ForgeCommonPlatformConfig;
import agency.highlysuspect.packages.platform.forge.ForgeInit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

public class ForgePlatformSupport
implements PlatformSupport {
    private final Map<Registry<?>, DeferredRegister<?>> deferredRegistries = new HashMap();
    private final Map<PlatformSupport.RegistryHandle<? extends ItemLike>, DispenseItemBehavior> dispenseBehaviorsToRegister = new HashMap<PlatformSupport.RegistryHandle<? extends ItemLike>, DispenseItemBehavior>();

    public ForgePlatformSupport() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::actuallyRegisterDispenserBehaviors);
    }

    private <T extends IForgeRegistryEntry<T>> DeferredRegister<T> getDeferredRegister(Registry<?> reg) {
        ForgeRegistry registrySpicy = RegistryManager.ACTIVE.getRegistry(reg.m_123023_());
        return this.deferredRegistries.computeIfAbsent(reg, arg_0 -> ForgePlatformSupport.lambda$getDeferredRegister$0((IForgeRegistry)registrySpicy, arg_0));
    }

    @Override
    public <T> PlatformSupport.RegistryHandle<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> thingMaker) {
        if (!id.m_135827_().equals("packages")) {
            throw new IllegalArgumentException("Forge enforces one modid per DeferredRegister");
        }
        RegistryObject obj = this.getDeferredRegister(registry).register(id.m_135815_(), thingMaker);
        return new RegistryObjectRegistryHandle(obj);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> makeBlockEntityType(PlatformSupport.BlockEntityFactory<T> factory, Block ... blocks) {
        return new BlockEntityType(factory::create, Set.of(blocks), null);
    }

    @Override
    public CreativeModeTab makeCreativeModeTab(ResourceLocation id, final Supplier<ItemStack> icon) {
        return new CreativeModeTab(id.m_135827_() + "." + id.m_135815_()){

            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }
        };
    }

    @Override
    public void registerDispenserBehavior(PlatformSupport.RegistryHandle<? extends ItemLike> item, DispenseItemBehavior behavior) {
        this.dispenseBehaviorsToRegister.put(item, behavior);
    }

    private void actuallyRegisterDispenserBehaviors(FMLCommonSetupEvent e) {
        this.dispenseBehaviorsToRegister.forEach((handle, behavior) -> DispenserBlock.m_52672_((ItemLike)((ItemLike)handle.get()), (DispenseItemBehavior)behavior));
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> makeMenuType(PlatformSupport.MyMenuSupplier<T> supplier) {
        return new MenuType(supplier::create);
    }

    @Override
    public void registerActionPacketHandler() {
        ForgeInit.CHANNEL.registerMessage(0, ActionPacket.class, ActionPacket::write, ActionPacket::read, (action, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            action.handle(player);
            ctx.setPacketHandled(true);
        });
    }

    @Override
    public CommonPlatformConfig makePlatformConfig() {
        return new ForgeCommonPlatformConfig();
    }

    private static /* synthetic */ DeferredRegister lambda$getDeferredRegister$0(IForgeRegistry registrySpicy, Registry __) {
        DeferredRegister deferred = DeferredRegister.create((IForgeRegistry)registrySpicy, (String)"packages");
        deferred.register(FMLJavaModLoadingContext.get().getModEventBus());
        return deferred;
    }

    private static class RegistryObjectRegistryHandle<T>
    implements PlatformSupport.RegistryHandle<T> {
        private final RegistryObject<T> obj;

        RegistryObjectRegistryHandle(RegistryObject<T> obj) {
            this.obj = obj;
        }

        @Override
        public T get() {
            return (T)this.obj.get();
        }

        @Override
        public ResourceLocation getId() {
            return this.obj.getId();
        }
    }
}

