/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.net;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.block.PackageBlockEntity;
import agency.highlysuspect.packages.net.PackageAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class ActionPacket {
    public static final ResourceLocation LONG_ID = Packages.id("action");
    public static final byte SHORT_ID = 0;
    public BlockPos pos;
    public InteractionHand hand;
    public PackageAction action;

    public ActionPacket(BlockPos pos, InteractionHand hand, PackageAction action) {
        this.pos = pos;
        this.hand = hand;
        this.action = action;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        this.action.write(buf);
    }

    public static ActionPacket read(FriendlyByteBuf buf) {
        return new ActionPacket(buf.m_130135_(), buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, PackageAction.read(buf));
    }

    public void handle(ServerPlayer sender) {
        sender.f_8924_.m_18707_(() -> {
            PackageBlockEntity be = ActionPacket.getPackageChecked(sender.f_19853_, (Player)sender, this.pos);
            if (be != null) {
                be.performAction((Player)sender, this.hand, this.action, false);
            }
        });
    }

    @Nullable
    private static PackageBlockEntity getPackageChecked(Level level, Player player, BlockPos pos) {
        PackageBlockEntity pbe;
        if (!level.m_46805_(pos) || player.m_142538_().m_123331_((Vec3i)pos) > 64.0) {
            return null;
        }
        if (!(level.m_8055_(pos).m_60734_() instanceof PackageBlock)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof PackageBlockEntity ? (pbe = (PackageBlockEntity)blockEntity) : null;
    }
}

