/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.client;

import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.block.PackageBlockEntity;
import agency.highlysuspect.packages.client.PackageActionBinding;
import agency.highlysuspect.packages.client.PackagesClient;
import agency.highlysuspect.packages.junk.TwelveDirection;
import agency.highlysuspect.packages.net.PNetClient;
import agency.highlysuspect.packages.net.PackageAction;
import agency.highlysuspect.packages.platform.ClientPlatformSupport;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PClientBlockEventHandlers {
    private static BlockPos lastPunchPosLegacy;
    private static long lastPunchTickLegacy;
    private static final int NOPE = 10000;

    public static boolean canAttack(Player player, Level level, BlockPos pos, Direction direction) {
        if (player.m_5833_()) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof PackageBlock)) {
            return false;
        }
        Direction frontDir = ((TwelveDirection)((Object)state.m_61143_(PackageBlock.FACING))).primaryDirection;
        if (direction != frontDir) {
            return false;
        }
        return !player.m_21120_(InteractionHand.MAIN_HAND).m_41735_(state);
    }

    public static boolean performPunchAction(Player player, Level level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        if (!(state.m_60734_() instanceof PackageBlock) || !(be instanceof PackageBlockEntity)) {
            return false;
        }
        PackageBlockEntity pkg = (PackageBlockEntity)be;
        PackageAction action = PClientBlockEventHandlers.getApplicableAction(player, PackageActionBinding.MainTrigger.PUNCH);
        if (action == null) {
            return false;
        }
        if (pkg.performAction(player, InteractionHand.MAIN_HAND, action, true)) {
            PNetClient.performAction(pos, InteractionHand.MAIN_HAND, action);
            lastPunchTickLegacy = level.m_46467_();
            return true;
        }
        return false;
    }

    public static void onInitializeClient(ClientPlatformSupport plat) {
        plat.installEarlyClientsideLeftClickCallback((player, level, pos, direction) -> {
            if (!PClientBlockEventHandlers.canAttack(player, level, pos, direction)) {
                return false;
            }
            return PClientBlockEventHandlers.performPunchAction(player, level, pos, direction);
        });
        plat.installClientsideHoldLeftClickCallback((player, level, hand, pos, direction) -> {
            if (PClientBlockEventHandlers.canAttack(player, level, pos, direction)) {
                if (!level.f_46443_ || PackagesClient.instance.config.punchRepeat < 0) {
                    return InteractionResult.CONSUME;
                }
                if (pos.equals((Object)lastPunchPosLegacy) && level.m_46467_() - lastPunchTickLegacy <= (long)PackagesClient.instance.config.punchRepeat) {
                    return InteractionResult.CONSUME;
                }
                lastPunchPosLegacy = pos;
                lastPunchTickLegacy = level.m_46467_();
                PClientBlockEventHandlers.performPunchAction(player, level, pos, direction);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        });
        plat.installClientsideUseBlockCallback((player, level, hand, hitResult) -> {
            if (!level.f_46443_ || player.m_5833_()) {
                return InteractionResult.PASS;
            }
            BlockPos pos = hitResult.m_82425_();
            BlockState state = level.m_8055_(pos);
            BlockEntity be = level.m_7702_(pos);
            if (!(state.m_60734_() instanceof PackageBlock) || !(be instanceof PackageBlockEntity)) {
                return InteractionResult.PASS;
            }
            PackageBlockEntity pkg = (PackageBlockEntity)be;
            Direction direction = hitResult.m_82434_();
            Direction frontDir = ((TwelveDirection)((Object)((Object)state.m_61143_(PackageBlock.FACING)))).primaryDirection;
            if (direction != frontDir) {
                return InteractionResult.PASS;
            }
            PackageAction action = PClientBlockEventHandlers.getApplicableAction(player, PackageActionBinding.MainTrigger.USE);
            if (action == null) {
                return InteractionResult.PASS;
            }
            if (pkg.performAction(player, hand, action, true)) {
                PNetClient.performAction(pos, hand, action);
                player.m_6674_(hand);
                return InteractionResult.CONSUME;
            }
            return player.m_6144_() ? InteractionResult.PASS : InteractionResult.CONSUME;
        });
    }

    @Nullable
    public static PackageAction getApplicableAction(Player player, PackageActionBinding.MainTrigger main) {
        PackageActionBinding leastWrongBinding = null;
        int leastWrongness = 10000;
        for (PackageActionBinding binding : PackagesClient.instance.config.sortedBindings) {
            int wrongness = PClientBlockEventHandlers.computeWrongness(player, binding, main);
            if (wrongness == 0) {
                return binding.action();
            }
            if (wrongness >= leastWrongness) continue;
            leastWrongness = wrongness;
            leastWrongBinding = binding;
        }
        if (leastWrongBinding != null) {
            return leastWrongBinding.action();
        }
        return null;
    }

    private static int computeWrongness(Player player, PackageActionBinding binding, PackageActionBinding.MainTrigger main) {
        if (binding.mainTrigger() == PackageActionBinding.MainTrigger.UNDEFINED || binding.mainTrigger() != main) {
            return 10000;
        }
        int wrongness = 0;
        if (binding.ctrl() != Screen.m_96637_()) {
            if (binding.ctrl()) {
                return 10000;
            }
            ++wrongness;
        }
        if (binding.alt() != Screen.m_96639_()) {
            if (binding.alt()) {
                return 10000;
            }
            ++wrongness;
        }
        if (binding.sneak() != player.m_6144_()) {
            if (binding.sneak()) {
                return 10000;
            }
            ++wrongness;
        }
        return wrongness;
    }
}

