/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.block;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PBlockEntityTypes;
import agency.highlysuspect.packages.block.PBlocks;
import agency.highlysuspect.packages.block.PackageMakerBlock;
import agency.highlysuspect.packages.container.PackageMakerMenu;
import agency.highlysuspect.packages.item.PItems;
import agency.highlysuspect.packages.item.PackageItem;
import agency.highlysuspect.packages.junk.ILoveMojang;
import agency.highlysuspect.packages.junk.PSoundEvents;
import agency.highlysuspect.packages.junk.PTags;
import agency.highlysuspect.packages.junk.PackageMakerStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PackageMakerBlockEntity
extends BlockEntity
implements Nameable,
WorldlyContainer,
MenuProvider {
    public static final int FRAME_SLOT = 0;
    public static final int INNER_SLOT = 1;
    public static final int DYE_SLOT = 2;
    public static final int EXTRA_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int SIZE = 5;
    private final NonNullList<ItemStack> inv = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    public static final int[] FRAME_AND_MISC = new int[]{0, 2, 3};
    public static final int[] INNER_AND_MISC = new int[]{1, 2, 3};
    public static final int[] OUTPUT = new int[]{4};
    private Component customName;

    public PackageMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PBlockEntityTypes.PACKAGE_MAKER.get(), pos, state);
    }

    public static boolean matchesFrameSlot(ItemStack stack) {
        if (!PackageMakerBlockEntity.matchesFrameOrInnerSlotLogic(stack)) {
            return false;
        }
        return !Packages.instance.config.packageMakerAllowlistMode || stack.m_204117_(PTags.ALLOWLIST_PACKAGE_MAKER_FRAME);
    }

    public static boolean matchesInnerSlot(ItemStack stack) {
        if (!PackageMakerBlockEntity.matchesFrameOrInnerSlotLogic(stack)) {
            return false;
        }
        return !Packages.instance.config.packageMakerAllowlistMode || stack.m_204117_(PTags.ALLOWLIST_PACKAGE_MAKER_INNER);
    }

    private static boolean matchesFrameOrInnerSlotLogic(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        if (stack.m_204117_(PTags.BANNED_FROM_PACKAGE_MAKER)) {
            return false;
        }
        Block b = ((BlockItem)item).m_40614_();
        BlockState state = b.m_49966_();
        return state.m_60815_();
    }

    public static boolean matchesDyeSlot(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(PTags.BANNED_FROM_PACKAGE_MAKER)) {
            return false;
        }
        return stack.m_41720_() instanceof DyeItem;
    }

    public static boolean matchesExtraSlot(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_204117_(PTags.THINGS_YOU_NEED_FOR_PACKAGE_CRAFTING);
    }

    public static ItemStack whatWouldBeCrafted(Container container) {
        ItemStack frame = container.m_8020_(0);
        ItemStack inner = container.m_8020_(1);
        ItemStack dye = container.m_8020_(2);
        ItemStack extra = container.m_8020_(3);
        if (!PackageMakerBlockEntity.matchesFrameSlot(frame)) {
            return ItemStack.f_41583_;
        }
        if (!PackageMakerBlockEntity.matchesInnerSlot(inner)) {
            return ItemStack.f_41583_;
        }
        if (!PackageMakerBlockEntity.matchesDyeSlot(dye)) {
            return ItemStack.f_41583_;
        }
        if (!PackageMakerBlockEntity.matchesExtraSlot(extra)) {
            return ItemStack.f_41583_;
        }
        Block frameBlock = ((BlockItem)frame.m_41720_()).m_40614_();
        Block innerBlock = ((BlockItem)inner.m_41720_()).m_40614_();
        DyeColor dyeColor = ((DyeItem)dye.m_41720_()).m_41089_();
        return ((PackageItem)((Object)PItems.PACKAGE.get())).createCustomizedStack(frameBlock, innerBlock, dyeColor);
    }

    public ItemStack whatWouldBeCrafted() {
        return PackageMakerBlockEntity.whatWouldBeCrafted((Container)this);
    }

    public void performCraft() {
        this.performCraft(1);
    }

    public void performCraft(int max) {
        boolean playedSound = false;
        for (int i = 0; i < max; ++i) {
            ItemStack wouldCraft = this.whatWouldBeCrafted();
            if (wouldCraft.m_41619_()) {
                return;
            }
            ItemStack currentOutputStack = (ItemStack)this.inv.get(4);
            if (currentOutputStack.m_41619_()) {
                this.inv.set(4, (Object)wouldCraft);
            } else if (currentOutputStack.m_41613_() != currentOutputStack.m_41741_() && ItemStack.m_150942_((ItemStack)currentOutputStack, (ItemStack)wouldCraft)) {
                currentOutputStack.m_41769_(1);
            } else {
                return;
            }
            ((ItemStack)this.inv.get(0)).m_41774_(1);
            ((ItemStack)this.inv.get(1)).m_41774_(1);
            ((ItemStack)this.inv.get(2)).m_41774_(1);
            ((ItemStack)this.inv.get(3)).m_41774_(1);
            this.m_6596_();
            if (this.f_58857_ == null || playedSound) continue;
            this.f_58857_.m_5594_(null, this.f_58858_, PSoundEvents.PACKAGE_MAKER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f);
            playedSound = true;
        }
    }

    public boolean hasFrame() {
        return !((ItemStack)this.inv.get(0)).m_41619_();
    }

    public boolean hasInner() {
        return !((ItemStack)this.inv.get(1)).m_41619_();
    }

    public boolean hasDye() {
        return !((ItemStack)this.inv.get(2)).m_41619_();
    }

    public boolean hasExtra() {
        return !((ItemStack)this.inv.get(3)).m_41619_();
    }

    public boolean hasOutput() {
        return !((ItemStack)this.inv.get(4)).m_41619_();
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return this.getStyle();
    }

    public PackageMakerStyle getStyle() {
        DyeColor dyeColor;
        Item item;
        Block innerBlock;
        Item item2;
        Block frameBlock;
        Item item3;
        ItemStack frameStack = (ItemStack)this.inv.get(0);
        ItemStack innerStack = (ItemStack)this.inv.get(1);
        ItemStack dyeStack = (ItemStack)this.inv.get(2);
        if (!frameStack.m_41619_() && (item3 = frameStack.m_41720_()) instanceof BlockItem) {
            BlockItem frameItem = (BlockItem)item3;
            v0 = frameItem.m_40614_();
        } else {
            v0 = frameBlock = null;
        }
        if (!innerStack.m_41619_() && (item2 = innerStack.m_41720_()) instanceof BlockItem) {
            BlockItem innerItem = (BlockItem)item2;
            v1 = innerItem.m_40614_();
        } else {
            v1 = innerBlock = null;
        }
        if (!dyeStack.m_41619_() && (item = dyeStack.m_41720_()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            dyeColor = dyeItem.m_41089_();
        } else {
            dyeColor = null;
        }
        DyeColor dyeColor2 = dyeColor;
        return new PackageMakerStyle(frameBlock, innerBlock, dyeColor2);
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return OUTPUT;
        }
        if (side == Direction.UP) {
            return FRAME_AND_MISC;
        }
        return INNER_AND_MISC;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 4;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> PackageMakerBlockEntity.matchesFrameSlot(stack);
            case 1 -> PackageMakerBlockEntity.matchesInnerSlot(stack);
            case 2 -> PackageMakerBlockEntity.matchesDyeSlot(stack);
            case 3 -> PackageMakerBlockEntity.matchesExtraSlot(stack);
            default -> false;
        };
    }

    public int m_6643_() {
        return 5;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inv) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inv.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inv, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inv, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inv.set(slot, (Object)stack);
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inv.clear();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new PackageMakerMenu(syncId, inv, (Container)this);
    }

    public Component m_7755_() {
        return this.m_8077_() ? this.customName : ILoveMojang.translatable(((PackageMakerBlock)((Object)PBlocks.PACKAGE_MAKER.get())).m_7705_(), new Object[0]);
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("packages$dataVersion", 1);
        if (this.m_8077_()) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        ContainerHelper.m_18973_((CompoundTag)tag, this.inv);
    }

    public void m_142466_(CompoundTag tag) {
        int dataVersion = tag.m_128451_("packages$dataVersion");
        this.customName = tag.m_128425_("CustomName", 8) ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : null;
        this.inv.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inv);
        if (dataVersion == 0) {
            this.inv.set(4, (Object)((ItemStack)this.inv.get(3)));
            this.inv.set(3, (Object)ItemStack.f_41583_);
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            Packages.instance.proxy.forceChunkRerender(this.f_58857_, this.m_58899_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

