/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.block;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PBlockEntityTypes;
import agency.highlysuspect.packages.block.PBlocks;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.junk.ILoveMojang;
import agency.highlysuspect.packages.junk.PTags;
import agency.highlysuspect.packages.junk.PackageContainer;
import agency.highlysuspect.packages.junk.PackageStyle;
import agency.highlysuspect.packages.junk.TwelveDirection;
import agency.highlysuspect.packages.net.PackageAction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class PackageBlockEntity
extends BlockEntity
implements Container,
Nameable {
    private PackageStyle style = PackageStyle.ERROR_LOL;
    private final PackageContainer container = new PackageContainer().addListener(c -> this.m_6596_());
    private ItemStack stickyStack = ItemStack.f_41583_;
    private Component customName;

    public PackageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PBlockEntityTypes.PACKAGE.get(), pos, state);
    }

    public PackageStyle getStyle() {
        return this.style;
    }

    public void setStyle(PackageStyle style) {
        this.style = style;
    }

    public PackageContainer getContainer() {
        return this.container;
    }

    public boolean canBeSticky() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (!this.f_58857_.m_8055_(this.m_58899_().m_142300_(dir)).m_204336_(PTags.STICKY)) continue;
            return true;
        }
        return false;
    }

    public boolean isSticky() {
        return this.canBeSticky() && !this.stickyStack.m_41619_();
    }

    public void updateStickyStack() {
        boolean anythingChanged = this.updateStickyStack0();
        if (anythingChanged) {
            this.m_6596_();
        }
    }

    private boolean updateStickyStack0() {
        if (!this.canBeSticky()) {
            this.stickyStack = ItemStack.f_41583_;
            return true;
        }
        if (this.stickyStack.m_41619_() || !this.stickyStack.m_41619_() && !this.container.m_7983_()) {
            this.stickyStack = this.container.getFilterStack().m_41777_();
            return !this.stickyStack.m_41619_();
        }
        return false;
    }

    public ItemStack getStickyStack() {
        return this.stickyStack;
    }

    public boolean performAction(Player player, InteractionHand hand, PackageAction action, boolean simulate) {
        SoundEvent event;
        boolean didAnything;
        if (action.isInsert()) {
            didAnything = this.playerInsert(player, hand, action, simulate);
        } else {
            didAnything = this.playerTakeDropLeftovers(player, hand, action, simulate);
            if (!didAnything && !this.stickyStack.m_41619_()) {
                didAnything = true;
                this.stickyStack = ItemStack.f_41583_;
            }
        }
        this.updateStickyStack0();
        if (didAnything && this.f_58857_ != null && Packages.instance.config.interactionSounds && !player.m_21023_(MobEffects.f_19609_) && (event = action.getSoundEvent()) != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), event, SoundSource.BLOCKS, action.getSoundVolume(), action.getSoundPitch(this.f_58857_));
        }
        return didAnything;
    }

    public boolean playerInsert(Player player, InteractionHand hand, PackageAction action, boolean simulate) {
        int x;
        int handSlot = PackageBlockEntity.handToSlotId(player, hand);
        if (!action.isInsert()) {
            throw new IllegalArgumentException("playerInsert only supports insertion actions, not " + action);
        }
        if (action == PackageAction.INSERT_ALL) {
            int favoriteSlot = player.m_21120_(hand).m_41619_() && this.container.m_7983_() ? this.slotWithALot(player).orElse(handSlot) : handSlot;
            boolean didAnything = false;
            IntIterator iterator = PackageBlockEntity.handSlotFirst(player, favoriteSlot).intIterator();
            while (iterator.hasNext()) {
                int inserted = this.insert0(player, iterator.nextInt(), Integer.MAX_VALUE, simulate);
                if (inserted == 0) continue;
                didAnything = true;
            }
            return didAnything;
        }
        int n = x = action == PackageAction.INSERT_ONE ? 1 : Integer.MAX_VALUE;
        if (this.container.m_7983_()) {
            return this.insert0(player, handSlot, x, simulate) > 0;
        }
        IntIterator iterator = PackageBlockEntity.handSlotFirst(player, handSlot).intIterator();
        while (iterator.hasNext()) {
            int inserted = this.insert0(player, iterator.nextInt(), x, simulate);
            if (inserted == 0) continue;
            return true;
        }
        return false;
    }

    private int insert0(Player player, int slot, int maxAmountToInsert, boolean simulate) {
        ItemStack toInsert = player.m_150109_().m_8020_(slot).m_41777_();
        ItemStack leftover = this.container.insert(toInsert, maxAmountToInsert, simulate);
        if (!simulate) {
            player.m_150109_().m_6836_(slot, leftover);
        }
        return toInsert.m_41613_() - (leftover.m_41619_() ? 0 : leftover.m_41613_());
    }

    private Optional<Integer> slotWithALot(Player player) {
        HashMap<Item, MutableInt> runningTotal = new HashMap<Item, MutableInt>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack here = player.m_150109_().m_8020_(i);
            if (here.m_41619_() || !this.container.allowedInPackageAtAll(here)) continue;
            runningTotal.computeIfAbsent(here.m_41720_(), __ -> new MutableInt(0)).add(here.m_41613_());
        }
        return runningTotal.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).flatMap(item -> {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (player.m_150109_().m_8020_(i).m_41720_() != item) continue;
                return Optional.of(i);
            }
            return Optional.empty();
        });
    }

    public PlayerTakeResult playerTake(Player player, InteractionHand hand, PackageAction action, boolean simulate) {
        int maxAmountToTake = switch (action) {
            case PackageAction.TAKE_ONE -> 1;
            case PackageAction.TAKE_STACK -> {
                int completionAmount;
                ItemStack held = player.m_21120_(hand);
                if (this.container.matches(held) && (completionAmount = held.m_41741_() - held.m_41613_()) > 0) {
                    yield completionAmount;
                }
                yield this.container.maxStackAmountAllowed(this.container.getFilterStack());
            }
            case PackageAction.TAKE_ALL -> Integer.MAX_VALUE;
            default -> throw new IllegalArgumentException("take() only supports taking actions, not " + action);
        };
        ItemStack toGiveOverstack = this.container.take(maxAmountToTake, simulate);
        if (toGiveOverstack.m_41619_()) {
            return new PlayerTakeResult(false, Collections.emptyList());
        }
        if (simulate) {
            return new PlayerTakeResult(true, Collections.emptyList());
        }
        List<ItemStack> toGive = PackageContainer.flattenOverstack(toGiveOverstack);
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : toGive) {
            if (player.m_150109_().m_36054_(stack)) continue;
            leftovers.add(stack);
        }
        return new PlayerTakeResult(true, leftovers);
    }

    private boolean playerTakeDropLeftovers(Player player, InteractionHand hand, PackageAction action, boolean simulate) {
        PlayerTakeResult result = this.playerTake(player, hand, action, simulate);
        if (simulate || !result.successful() || result.leftovers().isEmpty() || this.f_58857_ == null) {
            return result.successful();
        }
        Vec3 spawnPos = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82549_(new Vec3(((TwelveDirection)((Object)this.m_58900_().m_61143_(PackageBlock.FACING))).primaryDirection.m_122432_()).m_82490_(0.8));
        for (ItemStack stack : result.leftovers()) {
            ItemEntity e = new ItemEntity(this.f_58857_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, stack, 0.0, 0.01, 0.0);
            e.m_32010_(10);
            this.f_58857_.m_7967_((Entity)e);
        }
        return true;
    }

    private static int handToSlotId(Player player, InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
    }

    private static IntList handSlotFirst(Player player, int handSlot) {
        int size = player.m_150109_().m_6643_();
        IntStream stream = handSlot == 0 ? IntStream.range(0, size) : (handSlot == size ? IntStream.concat(IntStream.of(handSlot), IntStream.range(0, size)) : IntStream.concat(IntStream.of(handSlot), IntStream.concat(IntStream.range(0, handSlot), IntStream.range(handSlot + 1, size))));
        return (IntList)stream.collect(IntArrayList::new, IntArrayList::add, IntList::addAll);
    }

    public int m_6643_() {
        return this.container.m_6643_();
    }

    public boolean m_7983_() {
        return this.container.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.container.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.container.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.container.m_6836_(slot, stack);
    }

    public int m_6893_() {
        return this.container.m_6893_();
    }

    public boolean m_6542_(Player player) {
        return this.container.m_6542_(player);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (!this.stickyStack.m_41619_() && !ItemStack.m_150942_((ItemStack)this.stickyStack, (ItemStack)stack)) {
            return false;
        }
        return this.container.m_7013_(slot, stack);
    }

    public void m_6211_() {
        this.container.m_6211_();
    }

    public void m_6596_() {
        this.updateStickyStack0();
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public Component m_7755_() {
        return this.m_8077_() ? this.customName : ILoveMojang.translatable(((PackageBlock)((Object)PBlocks.PACKAGE.get())).m_7705_(), new Object[0]);
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Object getRenderAttachmentData() {
        return this.getStyle();
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("PackageContents", (Tag)this.container.toTag());
        tag.m_128365_("PackageStyle", (Tag)this.style.toTag());
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128365_("StickyStack", (Tag)this.stickyStack.m_41739_(new CompoundTag()));
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.readFromTag(tag.m_128469_("PackageContents"));
        this.style = PackageStyle.fromTag(tag.m_128469_("PackageStyle"));
        this.customName = tag.m_128425_("CustomName", 8) ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : null;
        this.stickyStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("StickyStack"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public record PlayerTakeResult(boolean successful, List<ItemStack> leftovers) {
    }
}

