/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import com.google.gson.JsonElement;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackRecipeResult
implements IRecipeResult<ItemStack> {
    private final ItemStack _result;

    public static ItemStackRecipeResult from(ItemStack stack) {
        return new ItemStackRecipeResult(stack);
    }

    public static ItemStackRecipeResult from(FriendlyByteBuf buffer) {
        return new ItemStackRecipeResult(buffer.m_130267_());
    }

    public static ItemStackRecipeResult from(JsonElement jsonElement) {
        return new ItemStackRecipeResult(ItemHelper.stackFrom(jsonElement));
    }

    public static ItemStackRecipeResult from(ItemLike item) {
        return ItemStackRecipeResult.from(item, 1);
    }

    public static ItemStackRecipeResult from(ItemLike item, int amount) {
        return ItemStackRecipeResult.from(new ItemStack(item, amount));
    }

    @Override
    public ResourceLocation getId() {
        return Objects.requireNonNull(this._result.m_41720_().getRegistryName());
    }

    @Override
    public ItemStack getResult() {
        return this._result.m_41777_();
    }

    @Override
    public long getAmount() {
        return this._result.m_41619_() ? 0L : (long)this._result.m_41613_();
    }

    @Override
    public boolean isEmpty() {
        return this._result.m_41619_();
    }

    @Override
    public void serializeTo(FriendlyByteBuf buffer) {
        buffer.m_130055_(this._result);
    }

    @Override
    public JsonElement serializeTo() {
        return ItemHelper.stackToJSON(this._result);
    }

    public String toString() {
        return this._result.toString();
    }

    private ItemStackRecipeResult(ItemStack stack) {
        this._result = stack;
    }
}

