/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model.data;

import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class AbstractModelDataMap
implements IModelData {
    private final Map<ModelProperty<?>, Object> _map;

    protected AbstractModelDataMap() {
        this(8);
    }

    protected AbstractModelDataMap(int expectedMaxSize) {
        this._map = new IdentityHashMap(expectedMaxSize);
    }

    protected void addProperty(ModelProperty<?> property) {
        this._map.put(property, null);
    }

    protected <T> void addProperty(ModelProperty<T> property, T data) {
        this._map.put(property, data);
    }

    public boolean hasProperty(ModelProperty<?> property) {
        return this._map.containsKey(property);
    }

    @Nullable
    public <T> T getData(ModelProperty<T> property) {
        return (T)this._map.get(property);
    }

    @Nullable
    public <T> T setData(ModelProperty<T> property, T data) {
        Preconditions.checkArgument((boolean)property.test(data), (Object)"Invalid data for this property");
        return (T)this._map.put(property, data);
    }

    public int hashCode() {
        return this._map.hashCode();
    }
}

