/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AtlasSpriteSupplier
implements ResourceManagerReloadListener {
    public static final AtlasSpriteSupplier INSTANCE = new AtlasSpriteSupplier();
    private final Map<ResourceLocation, List<ResourceLocation>> _toBeStitched = Maps.newHashMap();
    private int _generation = 0;

    public static Supplier<ISprite> create(ResourceLocation spriteName, AtlasSpriteTextureMap map) {
        return AtlasSpriteSupplier.create(spriteName, map, false);
    }

    public static Supplier<ISprite> create(ResourceLocation spriteName, AtlasSpriteTextureMap map, boolean stitch) {
        if (stitch) {
            AtlasSpriteSupplier.INSTANCE._toBeStitched.computeIfAbsent(map.getTextureLocation(), loc -> Lists.newArrayList()).add(spriteName);
        }
        return new SpriteSupplier(spriteName, map);
    }

    public void m_6213_(ResourceManager resourceManager) {
        ++this._generation;
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre evt) {
        ResourceLocation atlasName = evt.getAtlas().m_118330_();
        if (this._toBeStitched.containsKey(atlasName)) {
            this._toBeStitched.get(atlasName).forEach(arg_0 -> ((TextureStitchEvent.Pre)evt).addSprite(arg_0));
        }
    }

    private AtlasSpriteSupplier() {
    }

    private static class SpriteSupplier
    implements Supplier<ISprite> {
        private final AtlasSpriteTextureMap _map;
        private final ResourceLocation _name;
        private int _lastKnownGeneration;
        private ISprite _cachedSprite;

        protected SpriteSupplier(ResourceLocation name, AtlasSpriteTextureMap map) {
            this._name = name;
            this._map = map;
            this._lastKnownGeneration = -1;
            this._cachedSprite = Sprite.EMPTY;
        }

        @Override
        public ISprite get() {
            if (this._lastKnownGeneration != AtlasSpriteSupplier.INSTANCE._generation) {
                this._cachedSprite = this._map.sprite(this._name);
                this._lastKnownGeneration = AtlasSpriteSupplier.INSTANCE._generation;
            }
            return this._cachedSprite;
        }
    }
}

