/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import top.theillusivec4.comforts.common.tileentity.ComfortsBaseTileEntity;

public abstract class ComfortsBaseTileEntityRenderer<T extends ComfortsBaseTileEntity>
implements BlockEntityRenderer<T> {
    public static final ModelLayerLocation SLEEPING_BAG_HEAD = new ModelLayerLocation(new ResourceLocation("comforts", "sleeping_bag_head"), "main");
    public static final ModelLayerLocation SLEEPING_BAG_FOOT = new ModelLayerLocation(new ResourceLocation("comforts", "sleeping_bag_foot"), "main");
    public static final ModelLayerLocation HAMMOCK_HEAD = new ModelLayerLocation(new ResourceLocation("comforts", "hammock_head"), "main");
    public static final ModelLayerLocation HAMMOCK_FOOT = new ModelLayerLocation(new ResourceLocation("comforts", "hammock_foot"), "main");
    private final String type;
    protected ModelPart headPiece;
    protected ModelPart footPiece;

    public ComfortsBaseTileEntityRenderer(BlockEntityRendererProvider.Context ctx, String type, ModelLayerLocation headModel, ModelLayerLocation footModel) {
        this.headPiece = ctx.m_173582_(headModel);
        this.footPiece = ctx.m_173582_(footModel);
        this.type = type;
    }

    public void render(ComfortsBaseTileEntity tileEntityIn, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Material material = new Material(InventoryMenu.f_39692_, new ResourceLocation("comforts", "entity/" + this.type + "/" + tileEntityIn.getColor().m_41065_()));
        Level world = tileEntityIn.m_58904_();
        if (world != null) {
            BlockState blockstate = tileEntityIn.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.m_52822_((BlockEntityType)BlockEntityType.f_58940_, BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)world, (BlockPos)tileEntityIn.m_58899_(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLightIn);
            this.renderPiece(matrixStackIn, bufferIn, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), material, i, combinedOverlayIn, false);
        } else {
            this.renderPiece(matrixStackIn, bufferIn, true, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, false);
            this.renderPiece(matrixStackIn, bufferIn, false, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, true);
        }
    }

    protected void renderPiece(PoseStack matrixStack, MultiBufferSource buffer, boolean isHead, Direction direction, Material material, int light, int overlay, boolean p_228847_8_) {
        this.headPiece.f_104207_ = isHead;
        this.footPiece.f_104207_ = !isHead;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.1875, p_228847_8_ ? -1.0 : 0.0);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + direction.m_122435_()));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer ivertexbuilder = material.m_119194_(buffer, RenderType::m_110446_);
        this.headPiece.m_104301_(matrixStack, ivertexbuilder, light, overlay);
        this.footPiece.m_104301_(matrixStack, ivertexbuilder, light, overlay);
        matrixStack.m_85849_();
    }
}

