/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyTextComponent
implements IProperty<Component> {
    final DirectStorage<Component> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyTextComponent(DirectStorage<Component> value) {
        this.value = value;
    }

    public PropertyTextComponent() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<Component> getType() {
        return Component.class;
    }

    @Override
    public Component set(Component value) {
        Component pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        Component value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.m_130083_(value);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readBoolean() ? buf.m_130238_() : null);
    }

    @Override
    public Component get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

