/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyInt
implements IProperty<Integer> {
    final DirectStorage<Integer> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyInt(DirectStorage<Integer> value) {
        this.value = value;
    }

    public PropertyInt() {
        this(DirectStorage.allocate(0));
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    public int setInt(int value) {
        return this.set(value);
    }

    public int getInt() {
        return this.value.get();
    }

    @Override
    public Integer set(Integer value) {
        Integer pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.value.get().intValue());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readInt());
    }

    @Override
    public Integer get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

