/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyBool
implements IProperty<Boolean> {
    final DirectStorage<Boolean> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyBool(DirectStorage<Boolean> value) {
        this.value = value;
    }

    public PropertyBool() {
        this(DirectStorage.allocate(false));
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public Boolean set(Boolean value) {
        Boolean pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.value.get().booleanValue());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readBoolean());
    }

    @Override
    public Boolean get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

