/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.HLTargetPoint;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;
import org.zeith.hammerlib.net.properties.IPropertyTile;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerListener {
    public static final List<BlockEntity> NEED_SYNC = new ArrayList<BlockEntity>();
    public static final List<BlockEntity> NEED_PROP_SYNC = new ArrayList<BlockEntity>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            BlockEntity tile;
            while (!NEED_SYNC.isEmpty()) {
                tile = NEED_SYNC.remove(0);
                if (tile instanceof ISyncableTile) {
                    ((ISyncableTile)tile).syncNow();
                    continue;
                }
                Network.sendToArea(new HLTargetPoint((Vec3i)tile.m_58899_(), 256.0, (ResourceKey<Level>)tile.m_58904_().m_46472_()), (IPacket)new SyncTileEntityPacket(tile));
            }
            while (!NEED_PROP_SYNC.isEmpty()) {
                tile = NEED_PROP_SYNC.remove(0);
                if (!(tile instanceof IPropertyTile)) continue;
                ((IPropertyTile)tile).syncPropertiesNow();
            }
        }
    }

    public static void syncProperties(BlockEntity tileEntity) {
        NEED_PROP_SYNC.add(tileEntity);
    }

    public static void syncTileEntity(BlockEntity tileEntity) {
        NEED_SYNC.add(tileEntity);
    }
}

