/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.recipe.BuildTagsEvent;

public class TagAdapter {
    static final Map<TagKey<Block>, Set<Block>> blockTags = new ConcurrentHashMap<TagKey<Block>, Set<Block>>();
    static final Map<TagKey<Item>, Set<Item>> itemTags = new ConcurrentHashMap<TagKey<Item>, Set<Item>>();

    public static void bindStaticTag(TagKey<Block> tag, Block ... blocks) {
        Set set = blockTags.computeIfAbsent(tag, b -> new HashSet());
        set.addAll(List.of(blocks));
    }

    public static void bindStaticTag(TagKey<Item> tag, Item ... blocks) {
        Set set = itemTags.computeIfAbsent(tag, b -> new HashSet());
        set.addAll(List.of(blocks));
    }

    public static void applyBlockTags(BuildTagsEvent<Block> evt) {
        blockTags.forEach(evt::addAllToTag);
    }

    public static void applyItemTags(BuildTagsEvent<Item> evt) {
        itemTags.forEach(evt::addAllToTag);
    }

    static {
        HammerLib.EVENT_BUS.addGenericListener(Block.class, TagAdapter::applyBlockTags);
        HammerLib.EVENT_BUS.addGenericListener(Item.class, TagAdapter::applyItemTags);
    }
}

