/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import org.lwjgl.opengl.GL11;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.java.itf.IntToIntFunction;

public class RenderUtils {
    public static float zLevel = 0.0f;
    public static final Function<ResourceLocation, TextureAtlasSprite> spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
    private static final Random rand = new Random();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static TextureAtlasSprite getMainSprite(ResourceLocation tex) {
        return spriteGetter.apply(tex);
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height) {
        float n = 0.00390625f;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_5483_(x, y + height, (double)zLevel).m_7421_((float)texX * n, (float)(texY + height) * n).m_5752_();
        vb.m_5483_(x + width, y + height, (double)zLevel).m_7421_((float)(texX + width) * n, (float)(texY + height) * n).m_5752_();
        vb.m_5483_(x + width, y, (double)zLevel).m_7421_((float)(texX + width) * n, (float)texY * n).m_5752_();
        vb.m_5483_(x, y, (double)zLevel).m_7421_((float)texX * n, (float)texY * n).m_5752_();
        tess.m_85914_();
    }

    public static void drawTexturedModalRect(PoseStack pose, float x, float y, float texX, float texY, float width, float height) {
        Matrix4f pose4f = pose.m_85850_().m_85861_();
        float n = 0.00390625f;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_85982_(pose4f, x, y + height, zLevel).m_7421_(texX * n, (texY + height) * n).m_5752_();
        vb.m_85982_(pose4f, x + width, y + height, zLevel).m_7421_((texX + width) * n, (texY + height) * n).m_5752_();
        vb.m_85982_(pose4f, x + width, y, zLevel).m_7421_((texX + width) * n, texY * n).m_5752_();
        vb.m_85982_(pose4f, x, y, zLevel).m_7421_(texX * n, texY * n).m_5752_();
        tess.m_85914_();
    }

    public static void drawFullTexturedModalRect(double x, double y, double width, double height) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_5483_(x, y + height, (double)zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        vb.m_5483_(x + width, y + height, (double)zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        vb.m_5483_(x + width, y, (double)zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        vb.m_5483_(x, y, (double)zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        tess.m_85914_();
    }

    public static void drawFullTexturedModalRect(PoseStack pose, float x, float y, float width, float height) {
        Matrix4f pose4f = pose.m_85850_().m_85861_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_85982_(pose4f, x, y + height, zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        vb.m_85982_(pose4f, x + width, y + height, zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        vb.m_85982_(pose4f, x + width, y, zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        vb.m_85982_(pose4f, x, y, zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        tess.m_85914_();
    }

    public static void drawColoredModalRect(double x, double y, double width, double height, int rgb) {
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vb.m_5483_(x, y + height, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_5483_(x + width, y + height, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_5483_(x + width, y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_5483_(x, y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        tess.m_85914_();
    }

    public static void drawColoredModalRect(PoseStack pose, float x, float y, float width, float height, int rgb) {
        Matrix4f pose4f = pose.m_85850_().m_85861_();
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vb.m_85982_(pose4f, x, y + height, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_85982_(pose4f, x + width, y + height, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_85982_(pose4f, x + width, y, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_85982_(pose4f, x, y, zLevel).m_85950_(r, g, b, a).m_5752_();
        tess.m_85914_();
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height, double zLevel) {
        float n = 0.00390625f;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_5483_(x, y + height, zLevel).m_7421_((float)texX * n, (float)(texY + height) * n).m_5752_();
        vb.m_5483_(x + width, y + height, zLevel).m_7421_((float)(texX + width) * n, (float)(texY + height) * n).m_5752_();
        vb.m_5483_(x + width, y, zLevel).m_7421_((float)(texX + width) * n, (float)texY * n).m_5752_();
        vb.m_5483_(x, y, zLevel).m_7421_((float)texX * n, (float)texY * n).m_5752_();
        tess.m_85914_();
    }

    public static void drawTexturedModalRect(double xCoord, double yCoord, @Nullable TextureAtlasSprite textureSprite, double widthIn, double heightIn) {
        float minU = textureSprite == null ? 0.0f : textureSprite.m_118409_();
        float minV = textureSprite == null ? 0.0f : textureSprite.m_118411_();
        float maxU = textureSprite == null ? 1.0f : textureSprite.m_118410_();
        float maxV = textureSprite == null ? 1.0f : textureSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexbuffer.m_5483_(xCoord, yCoord + heightIn, 0.0).m_7421_(minU, maxV).m_5752_();
        vertexbuffer.m_5483_(xCoord + widthIn, yCoord + heightIn, 0.0).m_7421_(maxU, maxV).m_5752_();
        vertexbuffer.m_5483_(xCoord + widthIn, yCoord, 0.0).m_7421_(maxU, minV).m_5752_();
        vertexbuffer.m_5483_(xCoord, yCoord, 0.0).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedModalRect(PoseStack pose, float xCoord, float yCoord, @Nullable TextureAtlasSprite textureSprite, float widthIn, float heightIn) {
        Matrix4f pose4f = pose.m_85850_().m_85861_();
        float minU = textureSprite == null ? 0.0f : textureSprite.m_118409_();
        float minV = textureSprite == null ? 0.0f : textureSprite.m_118411_();
        float maxU = textureSprite == null ? 1.0f : textureSprite.m_118410_();
        float maxV = textureSprite == null ? 1.0f : textureSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexbuffer.m_85982_(pose4f, xCoord, yCoord + heightIn, 0.0f).m_7421_(minU, maxV).m_5752_();
        vertexbuffer.m_85982_(pose4f, xCoord + widthIn, yCoord + heightIn, 0.0f).m_7421_(maxU, maxV).m_5752_();
        vertexbuffer.m_85982_(pose4f, xCoord + widthIn, yCoord, 0.0f).m_7421_(maxU, minV).m_5752_();
        vertexbuffer.m_85982_(pose4f, xCoord, yCoord, 0.0f).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexbuffer.m_5483_(left + width, top, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        vertexbuffer.m_5483_(left, top, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        vertexbuffer.m_5483_(left, top + height, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        vertexbuffer.m_5483_(left + width, top + height, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor, double zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vb.m_5483_(left + width, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        vb.m_5483_(left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        vb.m_5483_(left, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        vb.m_5483_(left + width, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tess.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawTextRGBA(Font font, PoseStack stack, String s, int x, int y, int r, int g, int b, int a) {
        font.m_92883_(stack, s, (float)x, (float)y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawTextRGBA(Font font, PoseStack stack, Component s, int x, int y, int r, int g, int b, int a) {
        font.m_92889_(stack, s, (float)x, (float)y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawLine(Vector3d start, Vector3d end, int color, float size) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        ColorHelper.glColor1ia(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)start.f_86214_, (double)start.f_86215_, (double)start.f_86216_);
        GL11.glVertex3d((double)end.f_86214_, (double)end.f_86215_, (double)end.f_86216_);
        GL11.glEnd();
        GL11.glPopMatrix();
        RenderSystem.m_69493_();
        ColorHelper.glColor1ia(-1);
    }

    public static void drawBrokenLine(int color, float size, Vector3d ... points) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        ColorHelper.glColor1ia(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        for (Vector3d point : points) {
            GL11.glVertex3d((double)point.f_86214_, (double)point.f_86215_, (double)point.f_86216_);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        RenderSystem.m_69493_();
        ColorHelper.glColor1ia(-1);
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderColorfulLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        RenderSystem.m_69424_((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        int a = rgba >> 24 & 0xFF;
        VertexConsumer VertexConsumer2 = buffers.m_6299_(RenderType.m_110502_());
        matrix.m_85836_();
        for (int i = 0; i < rayCount; ++i) {
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.m_85850_().m_85861_();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.m_85849_();
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        VertexConsumer VertexConsumer2 = buffers.m_6299_(RenderType.m_110502_());
        matrix.m_85836_();
        for (int i = 0; i < rayCount; ++i) {
            int irgba = rgba.applyAsInt(i);
            int r = irgba >> 16 & 0xFF;
            int g = irgba >> 8 & 0xFF;
            int b = irgba & 0xFF;
            int a = irgba >> 24 & 0xFF;
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rand.nextFloat() * 360.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.m_85850_().m_85861_();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.m_85849_();
    }

    private static void vertex01(VertexConsumer p_229061_0_, Matrix4f p_229061_1_, int r, int g, int b, int a) {
        p_229061_0_.m_85982_(p_229061_1_, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        p_229061_0_.m_85982_(p_229061_1_, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
    }

    private static void vertex2(VertexConsumer p_229060_0_, Matrix4f p_229060_1_, float p_229060_2_, float p_229060_3_, int r, int g, int b) {
        p_229060_0_.m_85982_(p_229060_1_, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_229062_0_, Matrix4f p_229062_1_, float p_229062_2_, float p_229062_3_, int r, int g, int b) {
        p_229062_0_.m_85982_(p_229062_1_, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_229063_0_, Matrix4f p_229063_1_, float p_229063_2_, float p_229063_3_, int r, int g, int b) {
        p_229063_0_.m_85982_(p_229063_1_, 0.0f, p_229063_2_, p_229063_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    public static void drawHorizontalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((double)right, (double)top, 0.0).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_5483_((double)left, (double)top, 0.0).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_5483_((double)left, (double)bottom, 0.0).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferbuilder.m_5483_((double)right, (double)bottom, 0.0).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawVerticalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((double)right, (double)top, 0.0).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferbuilder.m_5483_((double)left, (double)top, 0.0).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_5483_((double)left, (double)bottom, 0.0).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_5483_((double)right, (double)bottom, 0.0).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawRect(PoseStack pose, int x, int y, int width, int height, int color) {
        RenderSystem.m_69472_();
        RenderUtils.drawColoredModalRect(pose, x, y, width, height, color);
        RenderSystem.m_69493_();
    }

    public static class PlayerRenderUtil {
        public static void rotateIfSneaking(Player player) {
            if (player.m_6144_()) {
                PlayerRenderUtil.applySneakingRotation();
            }
        }

        public static void applySneakingRotation() {
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            GL11.glRotatef((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
        }

        public static void translateToHeadLevel(Player player) {
            GL11.glTranslatef((float)0.0f, (float)(-player.m_20192_()), (float)0.0f);
            if (player.m_6144_()) {
                GL11.glTranslatef((float)(0.25f * Mth.m_14031_((float)(player.m_146908_() * (float)Math.PI / 180.0f))), (float)(0.25f * Mth.m_14089_((float)(player.m_146908_() * (float)Math.PI / 180.0f))), (float)0.0f);
            }
        }

        public static void translateToFace() {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-4.35f, (float)-1.27f);
        }

        public static void defaultTransforms() {
            GL11.glTranslatef((float)0.0f, (float)3.0f, (float)1.0f);
            GL11.glScalef((float)0.55f, (float)0.55f, (float)0.55f);
        }

        public static void translateToChest() {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-3.2f, (float)-0.85f);
        }
    }
}

