/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.util.java.Cast;

@SimplyRegister
public class ContainerAPI {
    @RegistryName(value="tile_container")
    public static final MenuType<AbstractContainerMenu> TILE_CONTAINER = IForgeMenuType.create((windowId, playerInv, extraData) -> {
        BlockEntity tile = playerInv.f_35978_.f_19853_.m_7702_(extraData.m_130135_());
        return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(playerInv.f_35978_, windowId)).orElse(null);
    });

    public static MenuProvider forTile(final BlockEntity tile) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Cast.optionally(tile, IContainerTile.class).map(IContainerTile::getDisplayName).orElseGet(() -> tile.m_58900_().m_60734_().m_49954_());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
                return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(player, windowId)).orElse(null);
            }
        };
    }

    public static <T extends BlockEntity> void openContainerTile(Player player, T tile) {
        if (player instanceof ServerPlayer && tile != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)ContainerAPI.forTile(tile), buf -> buf.m_130064_(tile.m_58899_()));
        }
    }
}

