/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;

public class ResourceUtils {
    public static InputStream getResourceAsStream(ResourceLocation resource) throws IOException {
        return ResourceUtils.getResource(resource).m_6679_();
    }

    public static ReloadableResourceManager getResourceManager() {
        return (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
    }

    public static Resource getResource(String location) throws IOException {
        return ResourceUtils.getResource(new ResourceLocation(location));
    }

    public static Resource getResource(ResourceLocation location) throws IOException {
        return ResourceUtils.getResourceManager().m_142591_(location);
    }

    public static void registerReloadListener(ResourceManagerReloadListener reloadListener) {
        ResourceUtils.getResourceManager().m_7217_((PreparableReloadListener)reloadListener);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> loadResource(ResourceProvider resourceProvider, ResourceLocation loc) {
        try (Resource resource = resourceProvider.m_142591_(loc);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));){
                list = reader.lines().toList();
            }
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load MTL file: " + loc, ex);
        }
    }
}

