/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IRegistryDelegate;

public class BlockRenderingRegistry {
    private static boolean initialized = false;
    private static final Map<IRegistryDelegate<Block>, ICCBlockRenderer> blockRenderers = new HashMap<IRegistryDelegate<Block>, ICCBlockRenderer>();
    private static final Map<IRegistryDelegate<Fluid>, ICCBlockRenderer> fluidRenderers = new HashMap<IRegistryDelegate<Fluid>, ICCBlockRenderer>();
    private static final List<ICCBlockRenderer> globalRenderers = new ArrayList<ICCBlockRenderer>();

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher parentDispatcher = mc.m_91289_();
            mc.f_91052_ = new CCBlockRendererDispatcher(parentDispatcher, mc.m_91298_());
            initialized = true;
        }
    }

    public static synchronized void registerRenderer(Block block, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = blockRenderers.get(block.delegate);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for block. " + block.getRegistryName());
        }
        blockRenderers.put((IRegistryDelegate<Block>)block.delegate, renderer);
    }

    public static synchronized void registerRenderer(Fluid fluid, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = blockRenderers.get(fluid.delegate);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for fluid. " + fluid.getRegistryName());
        }
        fluidRenderers.put((IRegistryDelegate<Fluid>)fluid.delegate, renderer);
    }

    public static synchronized void registerGlobalRenderer(ICCBlockRenderer renderer) {
        globalRenderers.add(renderer);
    }

    @Deprecated
    public static synchronized void registerRenderer(ICCBlockRenderer renderer) {
        BlockRenderingRegistry.registerGlobalRenderer(renderer);
    }

    @Nullable
    static ICCBlockRenderer findFor(Block block, Predicate<ICCBlockRenderer> pred) {
        ICCBlockRenderer found = blockRenderers.get(block.delegate);
        if (found != null && pred.test(found)) {
            return found;
        }
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        return null;
    }

    @Nullable
    static ICCBlockRenderer findFor(Fluid fluid, Predicate<ICCBlockRenderer> pred) {
        ICCBlockRenderer found = fluidRenderers.get(fluid.delegate);
        if (found != null && pred.test(found)) {
            return found;
        }
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        return null;
    }
}

