/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.init;

import java.util.List;
import java.util.function.Supplier;
import mrthomas20121.tinkers_reforged.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedBlocks;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.common.registration.ConfiguredFeatureDeferredRegister;
import slimeknights.tconstruct.common.registration.PlacedFeatureDeferredRegister;

@Mod.EventBusSubscriber(modid="tinkers_reforged", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TinkersReforgedWorldGen {
    public static Supplier<List<OreConfiguration.TargetBlockState>> aluReplace = () -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)TinkersReforgedBlocks.aluminum_ore.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)TinkersReforgedBlocks.deepslate_aluminum_ore.get()).m_49966_()));
    public static Supplier<List<OreConfiguration.TargetBlockState>> redBerylReplace = () -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)TinkersReforgedBlocks.red_beryl_ore.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)TinkersReforgedBlocks.deepslate_red_beryl_ore.get()).m_49966_()));
    public static final ConfiguredFeatureDeferredRegister CONFIGURED_FEATURES = new ConfiguredFeatureDeferredRegister("tinkers_reforged");
    public static final PlacedFeatureDeferredRegister PLACED_FEATURES = new PlacedFeatureDeferredRegister("tinkers_reforged");
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> ALUMINUM_ORE = CONFIGURED_FEATURES.registerSupplier("aluminum_ore", () -> Feature.f_65731_, () -> new OreConfiguration(aluReplace.get(), TinkersReforgedConfig.COMMON.bauxiteOre.getSize()));
    public static RegistryObject<PlacedFeature> placedAluminumOre = PLACED_FEATURES.register("aluminum_ore", ALUMINUM_ORE, new PlacementModifier[]{CountPlacement.m_191628_((int)TinkersReforgedConfig.COMMON.bauxiteOre.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.bauxiteOre.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.bauxiteOre.getMaxY()))});
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> KEPU_ORE = CONFIGURED_FEATURES.registerSupplier("kepu_ore", () -> Feature.f_65731_, () -> new OreConfiguration((RuleTest)new TagMatchTest(Tags.Blocks.END_STONES), ((Block)TinkersReforgedBlocks.kepu_ore.get()).m_49966_(), TinkersReforgedConfig.COMMON.kepuOre.getSize()));
    public static RegistryObject<PlacedFeature> placedKepuOre = PLACED_FEATURES.register("kepu_ore", KEPU_ORE, new PlacementModifier[]{CountPlacement.m_191628_((int)TinkersReforgedConfig.COMMON.kepuOre.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.kepuOre.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.kepuOre.getMaxY()))});
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> EPIDOTE_ORE = CONFIGURED_FEATURES.registerSupplier("epidote_ore", () -> Feature.f_65731_, () -> new OreConfiguration(OreFeatures.f_195073_, ((Block)TinkersReforgedBlocks.deepslate_epidote_ore.get()).m_49966_(), TinkersReforgedConfig.COMMON.epidoteOre.getSize()));
    public static RegistryObject<PlacedFeature> placedEpidoteOre = PLACED_FEATURES.register("epidote_ore", EPIDOTE_ORE, new PlacementModifier[]{CountPlacement.m_191628_((int)TinkersReforgedConfig.COMMON.epidoteOre.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.epidoteOre.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.epidoteOre.getMaxY()))});
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> HUREAULITE_ORE = CONFIGURED_FEATURES.registerSupplier("hureaulite_ore", () -> Feature.f_65731_, () -> new OreConfiguration(OreFeatures.f_195073_, ((Block)TinkersReforgedBlocks.deepslate_hureaulite_ore.get()).m_49966_(), TinkersReforgedConfig.COMMON.hureauliteOre.getSize()));
    public static RegistryObject<PlacedFeature> placedHureauliteOre = PLACED_FEATURES.register("hureaulite_ore", HUREAULITE_ORE, new PlacementModifier[]{CountPlacement.m_191628_((int)TinkersReforgedConfig.COMMON.hureauliteOre.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.hureauliteOre.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.hureauliteOre.getMaxY()))});
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> RED_BERYL_ORE = CONFIGURED_FEATURES.registerSupplier("red_beryl_ore", () -> Feature.f_65731_, () -> new OreConfiguration(redBerylReplace.get(), TinkersReforgedConfig.COMMON.redBerylOre.getSize()));
    public static RegistryObject<PlacedFeature> placedRedBerylOre = PLACED_FEATURES.register("red_beryl_ore", RED_BERYL_ORE, new PlacementModifier[]{CountPlacement.m_191628_((int)TinkersReforgedConfig.COMMON.redBerylOre.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.redBerylOre.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)TinkersReforgedConfig.COMMON.redBerylOre.getMaxY()))});

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        Biome.BiomeCategory category = event.getCategory();
        if (TinkersReforgedWorldGen.isOverworldBiome(category)) {
            if (TinkersReforgedConfig.COMMON.bauxiteOre.isEnabled()) {
                placedAluminumOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, holder));
            }
            if (TinkersReforgedConfig.COMMON.epidoteOre.isEnabled()) {
                placedEpidoteOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, holder));
            }
            if (TinkersReforgedConfig.COMMON.hureauliteOre.isEnabled()) {
                placedHureauliteOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, holder));
            }
            if (TinkersReforgedConfig.COMMON.redBerylOre.isEnabled()) {
                placedRedBerylOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, holder));
            }
        }
        if (TinkersReforgedWorldGen.isEndBiome(category) && TinkersReforgedConfig.COMMON.kepuOre.isEnabled()) {
            placedKepuOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, holder));
        }
    }

    public static boolean isOverworldBiome(Biome.BiomeCategory category) {
        return category != Biome.BiomeCategory.NONE && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NETHER;
    }

    public static boolean isNetherBiome(Biome.BiomeCategory category) {
        return category == Biome.BiomeCategory.NETHER;
    }

    public static boolean isEndBiome(Biome.BiomeCategory category) {
        return category == Biome.BiomeCategory.THEEND;
    }
}

