/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeExtractorMappingSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<TreeExtractorMapping> {
    public TreeExtractorMapping fromJson(ResourceLocation recipeId, JsonObject json) {
        Block trunk = Blocks.f_50016_;
        Block leaves = Blocks.f_50016_;
        FluidStack fluid = FluidStack.EMPTY;
        if (json.has("trunk")) {
            trunk = RecipeJsonUtils.parseBlock((JsonElement)json.get("trunk"));
        }
        if (json.has("leaf")) {
            leaves = RecipeJsonUtils.parseBlock((JsonElement)json.get("leaf"));
        } else if (json.has("leaves")) {
            leaves = RecipeJsonUtils.parseBlock((JsonElement)json.get("leaves"));
        }
        if (json.has("result")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("result"));
        } else if (json.has("fluid")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("fluid"));
        }
        return new TreeExtractorMapping(recipeId, trunk, leaves, fluid);
    }

    @Nullable
    public TreeExtractorMapping fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Block trunk = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        Block leaves = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        FluidStack fluid = buffer.readFluidStack();
        return new TreeExtractorMapping(recipeId, trunk, leaves, fluid);
    }

    public void toNetwork(FriendlyByteBuf buffer, TreeExtractorMapping recipe) {
        buffer.m_130085_(recipe.trunk.getRegistryName());
        buffer.m_130085_(recipe.leaves.getRegistryName());
        buffer.writeFluidStack(recipe.fluid);
    }
}

