/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.FisherBoost;
import cofh.thermal.lib.util.managers.AbstractManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.apache.commons.lang3.tuple.Triple;

public class FisherManager
extends AbstractManager {
    private static final FisherManager INSTANCE = new FisherManager();
    protected Map<ComparableItemStack, Triple<ResourceLocation, Float, Float>> boostMap = new Object2ObjectOpenHashMap();

    public static FisherManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.boostMap.clear();
    }

    public boolean validBoost(ItemStack item) {
        return this.boostMap.containsKey(FisherManager.makeComparable(item));
    }

    public void addBoost(FisherBoost boost) {
        for (ItemStack ingredient : boost.getIngredient().m_43908_()) {
            this.boostMap.put(FisherManager.makeComparable(ingredient), (Triple<ResourceLocation, Float, Float>)Triple.of((Object)boost.getLootTable(), (Object)Float.valueOf(boost.getOutputMod()), (Object)Float.valueOf(boost.getUseChance())));
        }
    }

    public ResourceLocation getBoostLootTable(ItemStack item) {
        return this.validBoost(item) ? (ResourceLocation)this.boostMap.get(FisherManager.makeComparable(item)).getLeft() : BuiltInLootTables.f_78723_;
    }

    public float getBoostOutputMod(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(FisherManager.makeComparable(item)).getMiddle()).floatValue() : 1.0f;
    }

    public float getBoostUseChance(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(FisherManager.makeComparable(item)).getRight()).floatValue() : 1.0f;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map boosts = recipeManager.m_44054_(TCoreRecipeTypes.BOOST_FISHER);
        for (Map.Entry entry : boosts.entrySet()) {
            this.addBoost((FisherBoost)((Object)entry.getValue()));
        }
    }
}

