/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.config;

import cofh.core.config.IBaseConfig;
import cofh.lib.util.Constants;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.item.SatchelItem;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalCoreConfig
implements IBaseConfig {
    public static int deviceAugments = 3;
    public static int dynamoAugments = 4;
    public static int machineAugments = 4;
    public static int storageAugments = 3;
    public static int toolAugments = 4;
    public static Supplier<Boolean> keepEnergy = Constants.TRUE;
    public static Supplier<Boolean> keepItems = Constants.FALSE;
    public static Supplier<Boolean> keepFluids = Constants.FALSE;
    public static Supplier<Boolean> keepAugments = Constants.TRUE;
    public static Supplier<Boolean> keepRSControl = Constants.TRUE;
    public static Supplier<Boolean> keepSideConfig = Constants.TRUE;
    public static Supplier<Boolean> keepTransferControl = Constants.TRUE;
    public static Supplier<Boolean> defaultReconfigSides = Constants.TRUE;
    public static Supplier<Boolean> defaultRSControl = Constants.TRUE;
    public static Supplier<Boolean> defaultXPStorage = Constants.FALSE;
    public static Supplier<Boolean> permanentLava = Constants.FALSE;
    public static Supplier<Boolean> permanentWater = Constants.FALSE;
    public static Supplier<Boolean> enableVillagerTrades = Constants.TRUE;
    public static Supplier<Boolean> enableWandererTrades = Constants.TRUE;
    public static Supplier<Boolean> mobBlitzLightning = Constants.TRUE;
    private Supplier<Boolean> boolMobBasalz = Constants.TRUE;
    private Supplier<Boolean> boolMobBlitz = Constants.TRUE;
    private Supplier<Boolean> boolMobBlizz = Constants.TRUE;
    private Supplier<Boolean> boolStandaloneRedstoneFlux = Constants.FALSE;
    private Supplier<List<String>> listSatchelBans = Collections::emptyList;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Global Options");
        this.boolStandaloneRedstoneFlux = builder.comment("If TRUE, Redstone Flux will act as its own energy system and will NOT be interoperable with 'Forge Energy' - only enable this if you absolutely know what you are doing and want the Thermal Series to use a unique energy system.").define("Standalone Redstone Flux", this.boolStandaloneRedstoneFlux);
        keepEnergy = builder.comment("If TRUE, most Thermal Blocks will retain Energy when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Energy", keepEnergy);
        keepItems = builder.comment("If TRUE, most Thermal Blocks will retain Inventory Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Inventory", keepItems);
        keepFluids = builder.comment("If TRUE, most Thermal Blocks will retain Tank Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Tank Contents", keepFluids);
        keepAugments = builder.comment("If TRUE, Thermal Blocks will retain Augments when dropped.").define("Blocks Retain Augments", keepAugments);
        keepRSControl = builder.comment("If TRUE, Thermal Blocks will retain Redstone Control configuration when dropped.").define("Blocks Retain Redstone Control", keepRSControl);
        keepSideConfig = builder.comment("If TRUE, Thermal Blocks will retain Side configuration when dropped.").define("Blocks Retain Side Configuration", keepSideConfig);
        keepTransferControl = builder.comment("If TRUE, Thermal Blocks will retain Transfer Control configuration when dropped.").define("Blocks Retain Transfer Control", keepTransferControl);
        builder.pop();
        builder.push("Tools");
        builder.push("Satchel");
        String[] shulkerBoxes = new String[]{};
        try {
            shulkerBoxes = new String[]{"thermal:satchel", Items.f_42265_.getRegistryName().toString(), Items.f_42266_.getRegistryName().toString(), Items.f_42267_.getRegistryName().toString(), Items.f_42268_.getRegistryName().toString(), Items.f_42269_.getRegistryName().toString(), Items.f_42270_.getRegistryName().toString(), Items.f_42271_.getRegistryName().toString(), Items.f_42272_.getRegistryName().toString(), Items.f_42273_.getRegistryName().toString(), Items.f_42274_.getRegistryName().toString(), Items.f_42275_.getRegistryName().toString(), Items.f_42224_.getRegistryName().toString(), Items.f_42225_.getRegistryName().toString(), Items.f_42226_.getRegistryName().toString(), Items.f_42227_.getRegistryName().toString(), Items.f_42228_.getRegistryName().toString(), Items.f_42229_.getRegistryName().toString()};
        }
        catch (Throwable t) {
            ThermalCore.LOG.error("A Shulker Box was NULL. This is really bad.", t);
        }
        this.listSatchelBans = builder.comment("A list of Items by Resource Location which are NOT allowed in Satchels.").define("Denylist", new ArrayList<String>(Arrays.asList(shulkerBoxes)));
        builder.pop(2);
        builder.push("Mobs");
        this.boolMobBasalz = builder.comment("If TRUE, the Basalz Mob is enabled.").define("Basalz", this.boolMobBasalz);
        this.boolMobBlitz = builder.comment("If TRUE, the Blitz Mob is enabled.").define("Blitz", this.boolMobBlitz);
        this.boolMobBlizz = builder.comment("If TRUE, the Blizz Mob is enabled.").define("Blizz", this.boolMobBlizz);
        mobBlitzLightning = builder.comment("If TRUE, the Blitz can occasionally call down lightning bolts.").define("Blitz Lightning", mobBlitzLightning);
        builder.pop();
        builder.push("Augments");
        defaultReconfigSides = builder.comment("If TRUE, Side Reconfiguration is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Side Reconfiguration", defaultReconfigSides);
        defaultRSControl = builder.comment("If TRUE, Redstone Control is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Redstone Control", defaultRSControl);
        defaultXPStorage = builder.comment("If TRUE, XP Storage is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default XP Storage", defaultXPStorage);
        builder.pop();
        builder.push("Villagers");
        enableVillagerTrades = builder.comment("If TRUE, trades will be added to various Villagers.").define("Enable Villager Trades", enableVillagerTrades);
        enableWandererTrades = builder.comment("If TRUE, trades will be added to the Wandering Trader.").define("Enable Wandering Trader Trades", enableWandererTrades);
        builder.pop();
    }

    public void refresh() {
        ThermalEnergyHelper.standaloneRedstoneFlux = this.boolStandaloneRedstoneFlux.get();
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BASALZ, this.boolMobBasalz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLITZ, this.boolMobBlitz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLIZZ, this.boolMobBlizz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT, defaultReconfigSides.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT, defaultRSControl.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT, defaultXPStorage.get() == false);
        SatchelItem.setBannedItems((Collection<String>)this.listSatchelBans.get());
    }
}

