/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.client.gui.device.DeviceComposterScreen;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.compat.jei.device.RockGenCategory;
import cofh.thermal.core.compat.jei.device.TreeExtractorCategory;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class TCoreJeiPlugin
implements IModPlugin {
    public static final RecipeType<TreeExtractorMapping> TREE_EXTRACTOR = new RecipeType(TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR, TreeExtractorMapping.class);
    public static final RecipeType<RockGenMapping> ROCK_GEN = new RecipeType(TCoreRecipeTypes.ID_MAPPING_ROCK_GEN, RockGenMapping.class);

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = this.getRecipeManager();
        if (recipeManager == null) {
            return;
        }
        if (ThermalFlags.getFlag("device_tree_extractor").get().booleanValue()) {
            registration.addRecipes(TREE_EXTRACTOR, recipeManager.m_44013_(TCoreRecipeTypes.MAPPING_TREE_EXTRACTOR));
        }
        if (ThermalFlags.getFlag("device_rock_gen").get().booleanValue()) {
            registration.addRecipes(ROCK_GEN, recipeManager.m_44013_(TCoreRecipeTypes.MAPPING_ROCK_GEN));
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeExtractorCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalCore.BLOCKS.get("device_tree_extractor")), TCoreRecipeTypes.ID_MAPPING_TREE_EXTRACTOR)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RockGenCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalCore.BLOCKS.get("device_rock_gen")), TCoreRecipeTypes.ID_MAPPING_ROCK_GEN)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalCore.BLOCKS.get("device_tree_extractor")), new RecipeType[]{TREE_EXTRACTOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalCore.BLOCKS.get("device_composter")), new RecipeType[]{RecipeTypes.COMPOSTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalCore.BLOCKS.get("device_rock_gen")), new RecipeType[]{ROCK_GEN});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        int progressY = 35;
        int progressW = 24;
        int progressH = 16;
        registration.addRecipeClickArea(DeviceTreeExtractorScreen.class, 80, progressY, 16, progressH, new RecipeType[]{TREE_EXTRACTOR});
        registration.addRecipeClickArea(DeviceComposterScreen.class, 87, progressY, progressW, progressH, new RecipeType[]{RecipeTypes.COMPOSTING});
        registration.addRecipeClickArea(DeviceRockGenScreen.class, 84, progressY, progressW, progressH, new RecipeType[]{ROCK_GEN});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("thermal", "core");
    }

    private RecipeManager getRecipeManager() {
        RecipeManager recipeManager = null;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            recipeManager = level.m_7465_();
        }
        return recipeManager;
    }

    public static IRecipeSlotTooltipCallback catalystTooltip() {
        return (recipeSlotView, tooltip) -> tooltip.add(StringHelper.getTextComponent((String)"info.cofh.optional_catalyst"));
    }

    public static IRecipeSlotTooltipCallback defaultOutputTooltip(float baseChance) {
        return (recipeSlotView, tooltip) -> {
            float chance = Math.abs(baseChance);
            if (chance < 1.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance").m_130946_(": " + (int)(100.0f * chance) + "%"));
            } else if ((chance -= (float)((int)chance)) > 0.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance_additional").m_130946_(": " + (int)(100.0f * chance) + "%"));
            }
            if (baseChance >= 0.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.boostable").m_130940_(ChatFormatting.GOLD));
            }
        };
    }

    public static IRecipeSlotTooltipCallback catalyzedOutputTooltip(float baseChance, boolean catalyzable) {
        return (recipeSlotView, tooltip) -> {
            float chance = Math.abs(baseChance);
            if (chance < 1.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance").m_130946_(": " + (int)(100.0f * chance) + "%"));
            } else if ((chance -= (float)((int)chance)) > 0.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance_additional").m_130946_(": " + (int)(100.0f * chance) + "%"));
            }
            if (catalyzable && baseChance >= 0.0f) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.boostable").m_130940_(ChatFormatting.GOLD));
            }
        };
    }

    public static IRecipeSlotTooltipCallback defaultFluidTooltip() {
        return (recipeSlotView, tooltip) -> recipeSlotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(ingredient -> {
            if (FluidHelper.hasPotionTag((FluidStack)ingredient)) {
                FluidHelper.addPotionTooltipStrings((FluidStack)ingredient, (List)tooltip);
            }
        });
    }

    public static int tankSize(int size) {
        return ThermalClientConfig.jeiBucketTanks.get() != false ? 1000 : size;
    }

    public static IDrawable tankOverlay(IDrawable overlay) {
        return ThermalClientConfig.jeiBucketTanks.get() != false ? null : overlay;
    }

    public static int getCenteredOffset(Font font, String string, int xPos) {
        return (xPos * 2 - font.m_92895_(string)) / 2;
    }

    public static double roundToPlaces(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }
}

