/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.dynamo;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.dynamo.MagmaticFuel;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalFuelByInput;
import cofh.thermal.lib.compat.crt.base.CRTFuel;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.MagmaticFuel")
public class CRTMagmaticManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addFuel(String name, CTFluidIngredient ingredient, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        MagmaticFuel recipe = new CRTFuel(resourceLocation, energy).fluid(ingredient).fuel(MagmaticFuel::new);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    public void remove(IIngredient output) {
        throw new IllegalArgumentException("Magmatic Fuel only works with fluids! Please provide an IFluidStack");
    }

    @ZenCodeType.Method
    public void removeFuel(IFluidStack outputFluid) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalFuelByInput((IRecipeManager)this, new IFluidStack[]{outputFluid}));
    }

    public RecipeType<MagmaticFuel> getRecipeType() {
        return TCoreRecipeTypes.FUEL_MAGMATIC;
    }
}

