/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.NullFluidStorage;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.NullItemStorage;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceNullifierContainer;
import cofh.thermal.lib.block.entity.DeviceBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DeviceNullifierTile
extends DeviceBlockEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Filter");
    protected ItemStorageCoFH nullSlot = new NullItemStorage(item -> this.filter.valid(item)).setEnabled(() -> this.isActive);
    protected ItemStorageCoFH[] binSlots;
    protected FluidStorageCoFH nullTank = new NullFluidStorage(64000, fluid -> this.filter.valid(fluid)).setEnabled(() -> this.isActive);

    public DeviceNullifierTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_NULLIFIER_TILE.get(), pos, state);
        this.inventory.addSlot(this.nullSlot, StorageGroup.INPUT);
        this.binSlots = new ItemStorageCoFH[9];
        for (int i = 0; i < this.binSlots.length; ++i) {
            this.binSlots[i] = new ItemStorageCoFH(item -> this.filter.valid(item));
            this.inventory.addSlot(this.binSlots[i], StorageGroup.INTERNAL);
        }
        this.tankInv.addTank(this.nullTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    public boolean binHasItems() {
        for (ItemStorageCoFH slot : this.binSlots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void emptyBin() {
        for (ItemStorageCoFH slot : this.binSlots) {
            slot.clear();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceNullifierContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

